/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.iam.DWIAMProperties;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import java.util.HashMap;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

public class IAMIdentityService {
    private static final String KEY_TOKEN = "token";
    @Autowired
    private DWIAMProperties properties;

    public String getToken(String secretKey) throws Exception {
        HttpResponseModel iamResponse = this.login(secretKey);
        String responseBody = iamResponse.getResponseBody();
        JSONObject responseJson = new JSONObject(responseBody);
        return (String)responseJson.get(KEY_TOKEN);
    }

    public HttpResponseModel login(String secretKey) throws Exception {
        ServiceModel serviceModel = new ServiceModel();
        String invokeURL = this.properties.getApiPathLogin();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("secretKey", secretKey);
        params.put("identityType", "secretKey");
        serviceModel.setInvokeURL(invokeURL);
        serviceModel.setParams(params);
        serviceModel.setRequestMethod(DWRequestMethod.POST);
        HttpResponseModel iamResponse = (HttpResponseModel)IAMService.invoke(serviceModel);
        this.handleLoginWithError(iamResponse);
        return iamResponse;
    }

    public String login(String userId, String passwordHash) throws Exception {
        ServiceModel serviceModel = new ServiceModel();
        String invokeURL = this.properties.getApiPathLogin();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("passwordHash", passwordHash);
        params.put("identityType", KEY_TOKEN);
        serviceModel.setInvokeURL(invokeURL);
        serviceModel.setParams(params);
        serviceModel.setRequestMethod(DWRequestMethod.POST);
        HttpResponseModel iamResponse = (HttpResponseModel)IAMService.invoke(serviceModel);
        this.handleLoginWithError(iamResponse);
        String responseBody = iamResponse.getResponseBody();
        JSONObject responseJson = new JSONObject(responseBody);
        return (String)responseJson.get(KEY_TOKEN);
    }

    public void handleLoginWithError(HttpResponseModel response) throws Exception {
        String responseBody = response.getResponseBody();
        JSONObject responseJson = new JSONObject(responseBody);
        if (responseJson.has("code")) {
            throw new DWException(responseJson.getString("detailMessage"));
        }
    }
}

