/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.iot.mqtt.config;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.iot.mqtt.config.IMqttConfig;
import com.digiwin.app.iot.mqtt.utils.DWMqttConnOptsUtil;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;

public class DWMqttConfig
implements IMqttConfig,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log _log = LogFactory.getLog(DWMqttConfig.class);
    private static final String _CLASSTAG = "[DWMqttConfig] ";
    private String serverURI;
    private String clientId = "dummy";
    private int topicQos = 1;
    private boolean topicRetained = true;
    private long waitForCompletion = 10000L;
    private boolean mqttEnabled = false;
    private MqttCallback mqttCallback;
    private MqttConnectOptions connectOptions;
    private MqttClientPersistence persistence;
    private static DWMqttConfig dwDefaultMqttConfig;

    private static void init() {
        if (dwDefaultMqttConfig == null) {
            dwDefaultMqttConfig = DWMqttConfig.createDefault();
        }
    }

    public static DWMqttConfig createDefault() {
        String[] serverURIList = null;
        dwDefaultMqttConfig = new DWMqttConfig();
        String serverURI = DWApplicationConfigUtils.getProperty((String)"mqttSrvHost");
        boolean valided = false;
        if (StringUtils.isNotBlank((CharSequence)serverURI)) {
            serverURIList = serverURI.split(",");
            dwDefaultMqttConfig.setServerURI(serverURIList[0]);
            valided = DWMqttConfig.configValid(serverURIList);
        }
        if (valided) {
            String username = DWApplicationConfigUtils.getProperty((String)"mqttSrvUsername", (String)"");
            String password = DWApplicationConfigUtils.getProperty((String)"mqttSrvPassword", (String)"");
            String autoReconnect = DWApplicationConfigUtils.getProperty((String)"mqttSrvReconnect", (String)"true");
            String cleanSession = DWApplicationConfigUtils.getProperty((String)"mqttSrvCleanSession", (String)"false");
            String topicRetained = DWApplicationConfigUtils.getProperty((String)"mqttTopicRetained", (String)"true");
            String clientId = DWApplicationConfigUtils.getProperty((String)"mqttSrvClientId", (String)"superman999");
            String connectTimeout = DWApplicationConfigUtils.getProperty((String)"mqttSrvConnectTimeout", (String)"50");
            String topicQos = DWApplicationConfigUtils.getProperty((String)"mqttTopicQos", (String)"1");
            String waitForCompletion = DWApplicationConfigUtils.getProperty((String)"mqttWaitForCompletion", (String)"15000");
            dwDefaultMqttConfig.setMqttEnabled(valided);
            if (StringUtils.isBlank((CharSequence)clientId)) {
                clientId = UUID.randomUUID().toString();
            }
            dwDefaultMqttConfig.setClientId(clientId);
            dwDefaultMqttConfig.setTopicRetained(new Boolean(topicRetained));
            if (NumberUtils.isDigits((String)topicQos)) {
                dwDefaultMqttConfig.setTopicQos(Integer.parseInt(topicQos));
            }
            if (NumberUtils.isDigits((String)waitForCompletion)) {
                dwDefaultMqttConfig.setWaitForCompletion(Integer.parseInt(waitForCompletion));
            }
            MqttConnectOptions connectionOptions = new MqttConnectOptions();
            if (serverURIList.length > 1) {
                connectionOptions.setServerURIs(serverURIList);
            }
            if (StringUtils.isNotBlank((CharSequence)username)) {
                connectionOptions.setUserName(username);
            }
            if (StringUtils.isNotBlank((CharSequence)password)) {
                connectionOptions.setPassword(password.toCharArray());
            }
            if (StringUtils.isNotBlank((CharSequence)cleanSession)) {
                connectionOptions.setCleanSession(new Boolean(cleanSession).booleanValue());
            }
            if (StringUtils.isNotBlank((CharSequence)autoReconnect)) {
                connectionOptions.setAutomaticReconnect(new Boolean(autoReconnect).booleanValue());
            }
            if (NumberUtils.isDigits((String)connectTimeout)) {
                connectionOptions.setConnectionTimeout(Integer.parseInt(connectTimeout));
            }
            dwDefaultMqttConfig.setConnectOptions(connectionOptions);
        }
        return dwDefaultMqttConfig;
    }

    @Override
    public DWMqttConfig getCopiedConfigFromDefault() throws Exception {
        return this.clone();
    }

    private static boolean configValid(String ... serverURIs) {
        boolean isMqttEnabled = true;
        for (String mqttServerHost : serverURIs) {
            if (!StringUtils.isBlank((CharSequence)mqttServerHost) && !mqttServerHost.matches("^@(.*).@$")) continue;
            isMqttEnabled = false;
            _log.debug((Object)("[DWMqttConfig]  platform.properties:mqttSrvHost:" + mqttServerHost + ", mqtt enabled=" + isMqttEnabled));
        }
        return isMqttEnabled;
    }

    public DWMqttConfig clone() throws CloneNotSupportedException {
        DWMqttConfig dwMqttConfig = (DWMqttConfig)super.clone();
        MqttConnectOptions mqttConnectionOptions = dwDefaultMqttConfig.getConnectOptions();
        dwMqttConfig.setConnectOptions(DWMqttConnOptsUtil.cloneMqttConnectionOpts(mqttConnectionOptions));
        return dwMqttConfig;
    }

    @Override
    public String getServerURI() {
        return this.serverURI;
    }

    @Override
    public void setServerURI(String serverURI) {
        this.serverURI = serverURI;
    }

    @Override
    public boolean isTopicRetained() {
        return this.topicRetained;
    }

    public void setTopicRetained(boolean topicRetained) {
        this.topicRetained = topicRetained;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public int getTopicQos() {
        return this.topicQos;
    }

    public void setTopicQos(int topicQos) {
        this.topicQos = topicQos;
    }

    @Override
    public long getWaitForCompletion() {
        return this.waitForCompletion;
    }

    public void setWaitForCompletion(long waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    public boolean isMqttEnabled() {
        return this.mqttEnabled;
    }

    public void setMqttEnabled(boolean mqttEnabled) {
        this.mqttEnabled = mqttEnabled;
    }

    public static DWMqttConfig getDefaultMqttConfig() throws CloneNotSupportedException {
        return dwDefaultMqttConfig;
    }

    public MqttCallback getMqttCallback() {
        return this.mqttCallback;
    }

    public void setMqttCallback(MqttCallback mqttCallback) {
        this.mqttCallback = mqttCallback;
    }

    @Override
    public MqttConnectOptions getConnectOptions() {
        return this.connectOptions;
    }

    public void setConnectOptions(MqttConnectOptions connectOptions) {
        this.connectOptions = connectOptions;
    }

    public MqttClientPersistence getPersistence() {
        return this.persistence;
    }

    public void setPersistence(MqttClientPersistence persistence) {
        this.persistence = persistence;
    }

    static {
        try {
            DWMqttConfig.init();
        }
        catch (Exception e) {
            _log.info((Object)"[DWMqttConfig]  init() error", (Throwable)e);
        }
    }
}

