/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.iot.mqtt.config;

import com.digiwin.app.iot.mqtt.DWMqttProperties;
import com.digiwin.app.iot.mqtt.config.IMqttConfig;
import com.digiwin.app.iot.mqtt.utils.DWMqttConnOptsUtil;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;

public class DWMqttConfig
implements IMqttConfig,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log _log = LogFactory.getLog(DWMqttConfig.class);
    private static final String _CLASSTAG = "[DWMqttConfig] ";
    private String serverURI;
    private String clientId = "dummy";
    private int topicQos = 1;
    private boolean topicRetained = true;
    private long waitForCompletion = 10000L;
    private boolean mqttEnabled = false;
    private MqttCallback mqttCallback;
    private MqttConnectOptions connectOptions;
    private MqttClientPersistence persistence;
    private static DWMqttConfig dwDefaultMqttConfig;

    public static DWMqttConfig createDefault() {
        String[] serverURIList = null;
        dwDefaultMqttConfig = new DWMqttConfig();
        DWMqttProperties properties = DWMqttProperties.getProperties();
        String serverURI = properties.getHost();
        boolean valided = false;
        if (StringUtils.isNotBlank((CharSequence)serverURI)) {
            serverURIList = serverURI.split(",");
            dwDefaultMqttConfig.setServerURI(serverURIList[0]);
            valided = DWMqttConfig.configValid(serverURIList);
        }
        if (valided) {
            String password;
            String username;
            dwDefaultMqttConfig.setMqttEnabled(valided);
            String clientId = properties.getClientId();
            if (StringUtils.isBlank((CharSequence)clientId)) {
                clientId = UUID.randomUUID().toString();
            }
            dwDefaultMqttConfig.setClientId(clientId);
            dwDefaultMqttConfig.setTopicRetained(properties.getTopicRetained());
            dwDefaultMqttConfig.setTopicQos(properties.getTopicQos());
            dwDefaultMqttConfig.setWaitForCompletion(properties.getWaitForCompletion());
            MqttConnectOptions connectionOptions = new MqttConnectOptions();
            if (serverURIList.length > 1) {
                connectionOptions.setServerURIs(serverURIList);
            }
            if (StringUtils.isNotBlank((CharSequence)(username = properties.getUsername()))) {
                connectionOptions.setUserName(username);
            }
            if (StringUtils.isNotBlank((CharSequence)(password = properties.getPassword()))) {
                connectionOptions.setPassword(password.toCharArray());
            }
            connectionOptions.setCleanSession(properties.getCleanSession());
            connectionOptions.setAutomaticReconnect(properties.getAutoReconnect());
            connectionOptions.setConnectionTimeout(properties.getConnectTimeout());
            dwDefaultMqttConfig.setConnectOptions(connectionOptions);
        }
        return dwDefaultMqttConfig;
    }

    @Override
    public DWMqttConfig getCopiedConfigFromDefault() throws Exception {
        return this.clone();
    }

    private static boolean configValid(String ... serverURIs) {
        boolean isMqttEnabled = true;
        for (String mqttServerHost : serverURIs) {
            if (!StringUtils.isBlank((CharSequence)mqttServerHost) && !mqttServerHost.matches("^@(.*).@$")) continue;
            isMqttEnabled = false;
            _log.debug((Object)("[DWMqttConfig]  platform.properties:mqttSrvHost:" + mqttServerHost + ", mqtt enabled=" + isMqttEnabled));
        }
        return isMqttEnabled;
    }

    public DWMqttConfig clone() throws CloneNotSupportedException {
        DWMqttConfig dwMqttConfig = (DWMqttConfig)super.clone();
        MqttConnectOptions mqttConnectionOptions = dwDefaultMqttConfig.getConnectOptions();
        dwMqttConfig.setConnectOptions(DWMqttConnOptsUtil.cloneMqttConnectionOpts(mqttConnectionOptions));
        return dwMqttConfig;
    }

    @Override
    public String getServerURI() {
        return this.serverURI;
    }

    @Override
    public void setServerURI(String serverURI) {
        this.serverURI = serverURI;
    }

    @Override
    public boolean isTopicRetained() {
        return this.topicRetained;
    }

    public void setTopicRetained(boolean topicRetained) {
        this.topicRetained = topicRetained;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public int getTopicQos() {
        return this.topicQos;
    }

    public void setTopicQos(int topicQos) {
        this.topicQos = topicQos;
    }

    @Override
    public long getWaitForCompletion() {
        return this.waitForCompletion;
    }

    public void setWaitForCompletion(long waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    public boolean isMqttEnabled() {
        return this.mqttEnabled;
    }

    public void setMqttEnabled(boolean mqttEnabled) {
        this.mqttEnabled = mqttEnabled;
    }

    public static DWMqttConfig getDefaultMqttConfig() throws CloneNotSupportedException {
        return dwDefaultMqttConfig;
    }

    public MqttCallback getMqttCallback() {
        return this.mqttCallback;
    }

    public void setMqttCallback(MqttCallback mqttCallback) {
        this.mqttCallback = mqttCallback;
    }

    @Override
    public MqttConnectOptions getConnectOptions() {
        return this.connectOptions;
    }

    public void setConnectOptions(MqttConnectOptions connectOptions) {
        this.connectOptions = connectOptions;
    }

    public MqttClientPersistence getPersistence() {
        return this.persistence;
    }

    public void setPersistence(MqttClientPersistence persistence) {
        this.persistence = persistence;
    }
}

