/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.iot.mqtt.utils;

import com.digiwin.app.iot.mqtt.ClientType;
import com.digiwin.app.iot.mqtt.DWMqttClientFactory;
import com.digiwin.app.iot.mqtt.DWMqttConfiguration;
import com.digiwin.app.iot.mqtt.MqttActionType;
import com.digiwin.app.iot.mqtt.callback.DWMqttCallback;
import com.digiwin.app.iot.mqtt.model.DWMqttMessage;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class DWMqttAsyncUtil {
    private static final Log _log = LogFactory.getLog(DWMqttAsyncUtil.class);
    private static long connectTimeout = 5000L;
    private static int loopInterval = 500;

    public static long getConnectTimeout() {
        return connectTimeout;
    }

    public static void setConnectTimeout(long connectTimeout) {
        DWMqttAsyncUtil.connectTimeout = connectTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object publishMessage(String topic, String clientId, String message) throws Exception {
        DWMqttClientFactory clientFactory = DWMqttConfiguration.getInstance();
        MqttMessage mqttMessage = new MqttMessage(message.getBytes());
        mqttMessage.setRetained(clientFactory.isTopicRetained());
        mqttMessage.setQos(clientFactory.getTopicQos());
        DWMqttMessage dwMqttMessage = new DWMqttMessage();
        dwMqttMessage.setAction(MqttActionType.PUBLISH.toString());
        MqttDeliveryToken token = null;
        IMqttAsyncClient mqttClient = (IMqttAsyncClient)clientFactory.createAndConnectClient(clientId, ClientType.ASYNC);
        try {
            _log.debug((Object)("mqtt client(" + clientId + ") Publishing to..." + topic + ",payload=" + message));
            token = (MqttDeliveryToken)mqttClient.publish(topic, mqttMessage);
            _log.debug((Object)("mqtt client(" + clientId + ") Published"));
        }
        finally {
            if (mqttClient != null && mqttClient.isConnected()) {
                mqttClient.disconnect();
            }
            _log.debug((Object)("mqtt client(" + clientId + ",topic=" + topic + ") Disconnected..."));
            if (token != null) {
                dwMqttMessage.setActionSuccess(token.isComplete());
            }
        }
        return dwMqttMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object subscribeMessage(String topic, String clientId) throws Exception {
        DWMqttClientFactory clientFactory = DWMqttConfiguration.getInstance();
        int qos = clientFactory.getTopicQos();
        DWMqttCallback dwMqttCallback = new DWMqttCallback(topic, qos);
        DWMqttMessage dwMqttMessage = new DWMqttMessage();
        dwMqttMessage.setAction(MqttActionType.SUBSCRIBE.toString());
        IMqttAsyncClient mqttClient = (IMqttAsyncClient)clientFactory.createAndConnectClient(clientId, ClientType.ASYNC, (MqttCallback)dwMqttCallback);
        try {
            _log.debug((Object)("mqtt client(" + clientId + ") Subscribing ... " + topic));
            mqttClient.subscribe(topic, qos).waitForCompletion(clientFactory.getConnectTimeout());
            MqttMessage mqttMessage = null;
            for (int i = 0; i < 3; ++i) {
                Thread.sleep(loopInterval);
                Map responseMessage = (Map)dwMqttCallback.getNextMessage();
                if (responseMessage != null && responseMessage.containsKey("message")) {
                    String messageTopic = (String)responseMessage.get("topic");
                    mqttMessage = (MqttMessage)responseMessage.get("message");
                    String message = new String(mqttMessage.getPayload());
                    dwMqttMessage.setMessage(message);
                    _log.debug((Object)("-- mqtt(" + i + ")-- message topic=" + messageTopic + ", message=" + message));
                    break;
                }
                _log.debug((Object)("-- mqtt(" + i + ")--- message topic=null"));
            }
        }
        finally {
            dwMqttMessage.setActionSuccess(true);
            if (mqttClient != null && mqttClient.isConnected()) {
                mqttClient.disconnect();
            }
            _log.debug((Object)("mqtt client(" + clientId + ",topic=" + topic + ") Disconnected..."));
        }
        return dwMqttMessage;
    }
}

