/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.iot.mqtt.utils;

import com.digiwin.app.iot.mqtt.ClientType;
import com.digiwin.app.iot.mqtt.DWMqttClientV2Factory;
import com.digiwin.app.iot.mqtt.callback.DWMqttCallback;
import com.digiwin.app.iot.mqtt.config.DWMqttConfig;
import com.digiwin.app.iot.mqtt.config.IMqttConfig;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class DWMqttV2Util {
    private static final Log _log = LogFactory.getLog(DWMqttV2Util.class);
    private static int loopInterval = 500;

    public static Object sendMessage(String topic, String message) throws Exception {
        DWMqttConfig dwMqttConfig = DWMqttConfig.getDefaultMqttConfig().clone();
        IMqttDeliveryToken token = (IMqttDeliveryToken)DWMqttV2Util.sendMessage(topic, message, dwMqttConfig);
        return token;
    }

    public static Object sendMessage(String topic, String message, String clientId) throws Exception {
        DWMqttConfig dwMqttConfig = DWMqttConfig.getDefaultMqttConfig().clone();
        if (StringUtils.isNotBlank((CharSequence)clientId)) {
            dwMqttConfig.setClientId(clientId);
        }
        IMqttDeliveryToken token = (IMqttDeliveryToken)DWMqttV2Util.sendMessage(topic, message, dwMqttConfig);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object sendMessage(String topic, String message, IMqttConfig dwMqttConfig) throws Exception {
        DWMqttClientV2Factory clientFactory;
        if (dwMqttConfig == null) {
            clientFactory = new DWMqttClientV2Factory();
            dwMqttConfig = clientFactory.getMqttConfig();
        } else {
            clientFactory = new DWMqttClientV2Factory(dwMqttConfig);
        }
        MqttMessage mqttMessage = new MqttMessage(message.getBytes());
        mqttMessage.setRetained(dwMqttConfig.isTopicRetained());
        mqttMessage.setQos(dwMqttConfig.getTopicQos());
        IMqttAsyncClient mqttClient = null;
        IMqttDeliveryToken token = null;
        try {
            String clientId = dwMqttConfig.getClientId();
            mqttClient = (IMqttAsyncClient)clientFactory.createAndConnectClient(clientId, ClientType.ASYNC, null);
            token = mqttClient.publish(topic, mqttMessage);
            token.waitForCompletion(dwMqttConfig.getWaitForCompletion());
            _log.debug((Object)(clientId + " publishing to..." + topic + ",payload=" + message));
        }
        finally {
            if (mqttClient != null && mqttClient.isConnected()) {
                mqttClient.disconnect();
                _log.debug((Object)" -- mqtt disconnect");
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object sendMessage(String topic, String message, String clientId, DWMqttClientV2Factory clientFactory) throws Exception {
        DWMqttConfig dwMqttClent = clientFactory.getMqttConfig();
        MqttMessage mqttMessage = new MqttMessage(message.getBytes());
        mqttMessage.setRetained(dwMqttClent.isTopicRetained());
        mqttMessage.setQos(dwMqttClent.getTopicQos());
        IMqttAsyncClient mqttClient = null;
        IMqttDeliveryToken token = null;
        try {
            mqttClient = (IMqttAsyncClient)clientFactory.createAndConnectClient(clientId, ClientType.ASYNC, null);
            token = mqttClient.publish(topic, mqttMessage);
            token.waitForCompletion(dwMqttClent.getWaitForCompletion());
            _log.debug((Object)(clientId + " publishing to..." + topic + ",payload=" + message));
        }
        finally {
            if (mqttClient != null && mqttClient.isConnected()) {
                mqttClient.disconnect();
                _log.debug((Object)" -- mqtt disconnect");
            }
        }
        return token;
    }

    public static Object fetchMessage(String topic) throws Exception {
        DWMqttClientV2Factory clientFactory = new DWMqttClientV2Factory();
        Object mqttMessage = DWMqttV2Util.fetchMessage(topic, clientFactory.getMqttConfig().getClientId());
        return mqttMessage;
    }

    public static Object fetchMessage(String topic, DWMqttCallback dwMqttCallback) throws Exception {
        DWMqttClientV2Factory clientFactory = new DWMqttClientV2Factory();
        Object mqttMessage = DWMqttV2Util.fetchMessage(topic, clientFactory.getMqttConfig().getClientId());
        return mqttMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fetchMessage(String topic, String clientId) throws Exception {
        DWMqttClientV2Factory clientFactory = new DWMqttClientV2Factory();
        DWMqttConfig dwMqttConfig = clientFactory.getMqttConfig();
        IMqttAsyncClient mqttClient = null;
        MqttMessage mqttMessage = null;
        try {
            DWMqttCallback dwMqttCallback = new DWMqttCallback(topic);
            mqttClient = (IMqttAsyncClient)clientFactory.createAndConnectAsyncClient(clientId, (MqttCallback)dwMqttCallback);
            mqttClient.subscribe(topic, dwMqttConfig.getTopicQos()).waitForCompletion(dwMqttConfig.getWaitForCompletion());
            for (int i = 0; i < 3; ++i) {
                Thread.sleep(loopInterval);
                Map responseMessage = (Map)dwMqttCallback.getNextMessage();
                if (responseMessage != null) {
                    mqttMessage = (MqttMessage)responseMessage.get("message");
                    String messageTopic = (String)responseMessage.get("topic");
                    String message = new String(mqttMessage.getPayload());
                    _log.debug((Object)("-- mqtt(" + i + ")-- message topic=" + messageTopic + ", message=" + message));
                    break;
                }
                _log.debug((Object)("-- mqtt(" + i + ")--- message topic=null"));
            }
        }
        finally {
            if (mqttClient != null && mqttClient.isConnected()) {
                mqttClient.disconnect();
                _log.debug((Object)" +- mqtt disconnect");
            }
        }
        return mqttMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fetchMessage(String topic, DWMqttClientV2Factory clientFactory) throws Exception {
        DWMqttConfig dwMqttConfig = clientFactory.getMqttConfig();
        String clientId = dwMqttConfig.getClientId();
        IMqttAsyncClient mqttClient = null;
        MqttMessage mqttMessage = null;
        try {
            DWMqttCallback dwMqttCallback = new DWMqttCallback(topic);
            mqttClient = (IMqttAsyncClient)clientFactory.createAndConnectAsyncClient(clientId, (MqttCallback)dwMqttCallback);
            mqttClient.subscribe(topic, dwMqttConfig.getTopicQos()).waitForCompletion(dwMqttConfig.getWaitForCompletion());
            for (int i = 0; i < 3; ++i) {
                Thread.sleep(loopInterval);
                Map responseMessage = (Map)dwMqttCallback.getNextMessage();
                if (responseMessage != null) {
                    mqttMessage = (MqttMessage)responseMessage.get("message");
                    String messageTopic = (String)responseMessage.get("topic");
                    String message = new String(mqttMessage.getPayload());
                    _log.debug((Object)("-- mqtt(" + i + ")-- message topic=" + messageTopic + ", message=" + message));
                    break;
                }
                _log.debug((Object)("-- mqtt(" + i + ")--- message topic=null"));
            }
        }
        finally {
            if (mqttClient != null && mqttClient.isConnected()) {
                mqttClient.disconnect();
                _log.debug((Object)" +- mqtt disconnect");
            }
        }
        return mqttMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fetchMessageManually(String topic, DWMqttClientV2Factory clientFactory) throws Exception {
        DWMqttConfig dwMqttConfig = clientFactory.getMqttConfig();
        String clientId = dwMqttConfig.getClientId();
        IMqttAsyncClient mqttClient = null;
        MqttMessage mqttMessage = null;
        try {
            DWMqttCallback dwMqttCallback = new DWMqttCallback(topic);
            mqttClient = (IMqttAsyncClient)clientFactory.createAndConnectAsyncClient(clientId, (MqttCallback)dwMqttCallback);
            mqttClient.subscribe(topic, dwMqttConfig.getTopicQos()).waitForCompletion(dwMqttConfig.getWaitForCompletion());
            for (int i = 0; i < 3; ++i) {
                Thread.sleep(loopInterval);
                Map responseMessage = (Map)dwMqttCallback.getNextMessage();
                if (responseMessage != null) {
                    mqttMessage = (MqttMessage)responseMessage.get("message");
                    String messageTopic = (String)responseMessage.get("topic");
                    String message = new String(mqttMessage.getPayload());
                    _log.debug((Object)("-- mqtt(" + i + ")-- message topic=" + messageTopic + ", message=" + message));
                    break;
                }
                _log.debug((Object)("-- mqtt(" + i + ")--- message topic=null"));
            }
        }
        finally {
            if (mqttClient != null && mqttClient.isConnected()) {
                mqttClient.disconnect();
                _log.debug((Object)" +- mqtt disconnect");
            }
        }
        return mqttMessage;
    }
}

