/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.json.gson;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.json.gson.deserializer.DWBooleanDeserializer;
import com.digiwin.app.json.gson.deserializer.DWDateDeserializer;
import com.digiwin.app.json.gson.deserializer.DWNumberDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DWGsonProvider {
    private static Log log = LogFactory.getLog(DWGsonProvider.class);
    private static List<Class<?>> typeList = new ArrayList();
    private static List<Object> adapterList = new ArrayList<Object>();
    private static boolean enabledEmptyStrToNull = Boolean.valueOf(DWApplicationConfigUtils.getProperty((String)"dwJsonEmptyStrToNullEnabled", (String)"false"));
    public static boolean serializeNulls = Boolean.valueOf(DWApplicationConfigUtils.getProperty((String)"dwJsonSerializeNulls", (String)"true"));
    private static boolean emptyStrAdpaterLoaded = false;
    private static String datePattern = "yyyy/MM/dd HH:mm:ss";

    public static boolean getEnabledEmptyStrToNull() {
        return enabledEmptyStrToNull;
    }

    public static boolean getSerializeNulls() {
        return serializeNulls;
    }

    public static void registerTypeAdapter(Class<?> type, Object adpater) {
        typeList.add(type);
        adapterList.add(adpater);
    }

    public static boolean hasAdapterInstance(Class<?> adapterClazz) {
        return adapterList.stream().anyMatch(a -> a.getClass().equals(adapterClazz));
    }

    public static void setDateFormat(String pattern) {
        datePattern = pattern;
    }

    public static Gson getGson() {
        GsonBuilder builder = new GsonBuilder();
        if (serializeNulls) {
            builder.serializeNulls();
        }
        builder.setDateFormat(datePattern);
        if (enabledEmptyStrToNull && !emptyStrAdpaterLoaded) {
            emptyStrAdpaterLoaded = true;
            DWNumberDeserializer numberAdapter = new DWNumberDeserializer();
            DWGsonProvider.registerTypeAdapter(Integer.TYPE, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Integer.class, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Long.TYPE, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Long.class, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Float.TYPE, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Float.class, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Double.TYPE, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Double.class, numberAdapter);
            DWGsonProvider.registerTypeAdapter(BigDecimal.class, numberAdapter);
            DWBooleanDeserializer booleanAdaptor = new DWBooleanDeserializer();
            DWGsonProvider.registerTypeAdapter(Boolean.TYPE, booleanAdaptor);
            DWGsonProvider.registerTypeAdapter(Boolean.class, booleanAdaptor);
            DWGsonProvider.registerTypeAdapter(Date.class, new DWDateDeserializer(datePattern));
            ReflectiveTypeAdapterFactory.enableEmptyStrToNull();
        }
        if (log.isDebugEnabled()) {
            int i;
            log.debug((Object)("type list size = " + typeList.size()));
            for (i = 0; i < typeList.size(); ++i) {
                log.debug((Object)("type list index=" + i + ", class name=" + typeList.get(i).getCanonicalName()));
            }
            log.debug((Object)("adpater ist size = " + adapterList.size()));
            for (i = 0; i < adapterList.size(); ++i) {
                log.debug((Object)("adapter list index=" + i + ", class name=" + adapterList.get(i).getClass().getCanonicalName()));
            }
        }
        for (int i = 0; i < typeList.size(); ++i) {
            builder.registerTypeAdapter((Type)typeList.get(i), adapterList.get(i));
        }
        Gson gson = builder.create();
        return gson;
    }
}

