/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.scan;

import com.digiwin.loadbalance.scan.candidate.DWResourceHelper;
import com.digiwin.loadbalance.scan.candidate.DWTargetResource;
import com.digiwin.loadbalance.scan.candidate.VersionApiCandidate;
import com.digiwin.loadbalance.scan.metadata.ApiMetadata;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.Environment;

public class DWCommonScanner {
    private Log log = LogFactory.getLog(DWCommonScanner.class);
    Environment environment;
    List<VersionApiCandidate> apiCandidates;
    DWResourceHelper dwResourceHelper;

    public DWCommonScanner(Environment environment, List<VersionApiCandidate> apiCandidates, DWResourceHelper dwResourceHelper) {
        this.environment = environment;
        this.apiCandidates = apiCandidates;
        this.dwResourceHelper = dwResourceHelper;
    }

    public Set<ApiMetadata> scan() throws Exception {
        this.log.info((Object)("DWResourceHelper class is " + this.dwResourceHelper.getClass()));
        HashSet<ApiMetadata> versionPathSet = new HashSet<ApiMetadata>();
        List<DWTargetResource> targetResourceList = this.dwResourceHelper.getDWTargetResource(this.environment);
        this.log.info((Object)("DWCommonScanner searchResultSize:" + targetResourceList.size()));
        for (VersionApiCandidate apiCandidate : this.apiCandidates) {
            versionPathSet.addAll(apiCandidate.resolver(targetResourceList));
        }
        return versionPathSet;
    }
}

