/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.scan.candidate;

import com.digiwin.loadbalance.scan.candidate.DWTargetResource;
import com.digiwin.loadbalance.scan.candidate.VersionApiCandidate;
import com.digiwin.loadbalance.scan.metadata.ApiMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

public abstract class AbstractVersionApiCandidate
implements VersionApiCandidate {
    private static Log log = LogFactory.getLog(AbstractVersionApiCandidate.class);
    private AntPathMatcher antPathMatcher = new AntPathMatcher();
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory();

    public abstract List<ApiMetadata> resolverPathRegex(MetadataReader var1, String var2);

    @Override
    public List<ApiMetadata> resolver(List<DWTargetResource> targetResourceList) throws IOException {
        HashMap moduleApiMap = new HashMap(targetResourceList.size());
        targetResourceList.stream().filter(targetResource -> StringUtils.hasText((String)targetResource.getPrefix())).forEach(targetResource -> {
            for (Resource resource : targetResource.getResources()) {
                List<Resource> jarFileClassResouces = null;
                try {
                    jarFileClassResouces = this.extractClass(resource);
                }
                catch (IOException e) {
                    log.error((Object)"extractClass faile ", (Throwable)e);
                    continue;
                }
                for (Resource classResouce : jarFileClassResouces) {
                    MetadataReader metadataReader = null;
                    try {
                        byte[] bytes = IOUtils.toByteArray((InputStream)classResouce.getInputStream());
                        ByteArrayResource classbytesResource = new ByteArrayResource((byte[])bytes.clone());
                        metadataReader = this.getMetadataReaderFactory().getMetadataReader((Resource)classbytesResource);
                    }
                    catch (Throwable e) {
                        log.error((Object)"getMetadataReader faile ", e);
                        continue;
                    }
                    moduleApiMap.put(targetResource.getPrefix() + metadataReader.getClassMetadata().getClassName(), this.resolverPathRegex(metadataReader, targetResource.getPrefix()));
                }
            }
        });
        return moduleApiMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Resource> extractClass(Resource resource) throws IOException {
        ArrayList<Resource> classResouceList = new ArrayList<Resource>();
        if (resource.exists() && resource.getURL().getProtocol().equals("file") && !resource.getFile().isDirectory()) {
            log.debug((Object)("file resource :" + resource + " to extractClass class is " + resource.getClass() + " "));
            if (resource.getFilename().endsWith(".jar")) {
                log.debug((Object)("jar resource :" + resource + " to extractClass "));
                List<Resource> jarFileClassResouces = this.getJarFileClassResouces(resource);
                log.debug((Object)("jar resource :" + resource + "extractClass length: " + jarFileClassResouces.size()));
                return jarFileClassResouces;
            }
            if (resource.getFilename().endsWith(".class")) {
                classResouceList.add(resource);
            }
        } else if (resource.exists() && resource.getURL().getProtocol().equals("jar")) {
            log.debug((Object)("inner jar resource :" + resource + " to extractClass "));
            JarURLConnection jarUrlConnection = (JarURLConnection)resource.getURL().openConnection();
            String entryName = jarUrlConnection.getEntryName();
            JarFile jarFile = jarUrlConnection.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!this.getAntPathMatcher().match(entryName + "/**/*.class", jarEntry.getName())) continue;
                classResouceList.add((Resource)new InputStreamResource(jarFile.getInputStream(jarEntry)));
            }
            log.debug((Object)("inner resource :" + resource + "extractClass length: " + classResouceList.size()));
        }
        log.debug((Object)("resource :" + resource + " getclassLength:" + classResouceList.size()));
        return classResouceList;
    }

    private List<Resource> getJarFileClassResouces(Resource jarResource) throws IOException {
        ArrayList<Resource> classResourceList = new ArrayList<Resource>();
        JarFile jarFile = new JarFile(jarResource.getFile());
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (jarResource.getURL().toString().contains("aspectjtools-1.8.13")) {
                log.info((Object)("class info ======================" + jarEntry.getName()));
            }
            if (!jarEntry.getName().endsWith(".class")) continue;
            classResourceList.add((Resource)new InputStreamResource(jarFile.getInputStream(jarEntry)));
        }
        return classResourceList;
    }

    public final MetadataReaderFactory getMetadataReaderFactory() {
        return this.metadataReaderFactory;
    }

    public AntPathMatcher getAntPathMatcher() {
        return this.antPathMatcher;
    }
}

