/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.loadbalancer;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.digiwin.loadbalance.client.config.TenantServiceConfig;
import com.digiwin.loadbalance.matcher.DWMatcher;
import com.digiwin.loadbalance.region.RegionSwitch;
import com.digiwin.loadbalance.region.RegionSwitchEvent;
import com.digiwin.loadbalance.util.DWLoadBalanceRequestUtils;
import com.digiwin.loadbalance.watch.NacosServerListWatcher;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.context.ApplicationListener;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DWClientTenantRoundLoadBalancer
implements ServiceInstanceChooser,
ApplicationListener<RegionSwitchEvent> {
    private static Log log = LogFactory.getLog(DWClientTenantRoundLoadBalancer.class);
    private final AtomicInteger position;
    private DiscoveryClient discoveryClient;
    private Map<String, Cache<String, List<ServiceInstance>>> servicePathCacheMap;
    private TenantServiceConfig tenantServiceConfig;
    private String serviceId;
    private List<DWMatcher> matchers;
    private RegionSwitch regionSwitch;

    public DWClientTenantRoundLoadBalancer(DiscoveryClient discoveryClient, TenantServiceConfig tenantServiceConfig, String serviceId, NacosServerListWatcher nacosServerListWatcher, List<DWMatcher> matchers, RegionSwitch regionSwitch) throws NacosException {
        this.discoveryClient = discoveryClient;
        this.tenantServiceConfig = tenantServiceConfig;
        this.servicePathCacheMap = new ConcurrentHashMap<String, Cache<String, List<ServiceInstance>>>();
        this.serviceId = serviceId;
        this.position = new AtomicInteger(new Random().nextInt(1000));
        this.matchers = matchers;
        this.regionSwitch = regionSwitch;
        nacosServerListWatcher.watch(serviceId, event -> {
            if (event instanceof NamingEvent) {
                log.info((Object)("nacos NamingEvent in DWClientTenantRoundLoadBalancer  ServiceName:" + ((NamingEvent)event).getServiceName() + ",clusters:" + ((NamingEvent)event).getClusters()));
                this.servicePathCacheMap.clear();
            }
        });
    }

    public ServiceInstance choose(String serviceId) {
        HttpUriRequest request = DWLoadBalanceRequestUtils.getRequest();
        log.info((Object)("DWTenantRoundLoadBalancer choose start path:" + request.getURI().getPath()));
        String tenantId = this.getTentid();
        DWMatcher matcher = this.getMatcher(DWLoadBalanceRequestUtils.getRequest());
        String cacheKey = matcher.getCacheKey(DWLoadBalanceRequestUtils.getRequest());
        String tenantServiceVersion = this.tenantServiceConfig.getServiceVersion(tenantId);
        return this.filterInstance(tenantId, tenantServiceVersion, cacheKey, matcher, request, false);
    }

    public ServiceInstance filterInstance(String tenantId, String tenantServiceVersion, String cacheKey, DWMatcher matcher, HttpUriRequest request, boolean recalculate) {
        List<ServiceInstance> targetInstances = null;
        Cache pathListCache = this.servicePathCacheMap.get(tenantServiceVersion);
        if (Objects.isNull(pathListCache)) {
            pathListCache = CacheBuilder.newBuilder().initialCapacity(300).maximumSize(1000L).build();
            this.servicePathCacheMap.put(tenantServiceVersion, (Cache<String, List<ServiceInstance>>)pathListCache);
        }
        try {
            targetInstances = StringUtils.hasText((String)cacheKey) ? (List<ServiceInstance>)pathListCache.get((Object)cacheKey, () -> this.getInstances(tenantServiceVersion, request, matcher)) : this.getInstances(tenantServiceVersion, request, matcher);
        }
        catch (ExecutionException e) {
            log.error((Object)("fail to find serviceInstances tenantId:" + tenantId + " cacheKey:" + cacheKey + " serviceId:" + this.serviceId + " version:" + tenantServiceVersion), (Throwable)e);
        }
        log.info((Object)("DWTenantRoundLoadBalancer after patch match instanceLength: " + (CollectionUtils.isEmpty((Collection)targetInstances) ? "0" : Integer.valueOf(targetInstances.size()))));
        Optional<Predicate<? super ServiceInstance>> regionPredicateOptional = this.regionSwitch.getRegionPredicate(this.getTentid());
        if (regionPredicateOptional.isPresent() && !CollectionUtils.isEmpty((Collection)targetInstances)) {
            targetInstances = targetInstances.stream().filter(regionPredicateOptional.get()).collect(Collectors.toList());
        }
        log.info((Object)("DWTenantRoundLoadBalancer region match instanceLength: " + (CollectionUtils.isEmpty((Collection)targetInstances) ? "0" : Integer.valueOf(targetInstances.size()))));
        ServiceInstance serviceInstance = this.selectInstance(targetInstances, tenantId);
        if (!recalculate && this.instanceExpire(serviceInstance)) {
            log.info((Object)("instance not exist start recalculate serviceId:" + this.serviceId + ", key:" + cacheKey));
            pathListCache.invalidate((Object)cacheKey);
            return this.filterInstance(tenantId, tenantServiceVersion, cacheKey, matcher, request, !recalculate);
        }
        if (null != serviceInstance) {
            log.info((Object)(request.getURI().toString() + "targetInstance host:" + serviceInstance.getHost() + ",prot:" + serviceInstance.getPort() + ",version:" + (String)serviceInstance.getMetadata().get("version")));
        }
        return serviceInstance;
    }

    public boolean instanceExpire(ServiceInstance instance) {
        if (null == instance) {
            return true;
        }
        Optional<ServiceInstance> targetOptional = this.discoveryClient.getInstances(this.serviceId).stream().filter(memoryInstance -> memoryInstance.getPort() == instance.getPort() && Objects.equals(memoryInstance.getHost(), instance.getHost()) && Objects.equals(memoryInstance.getMetadata(), instance.getMetadata())).findFirst();
        return !targetOptional.isPresent();
    }

    List<ServiceInstance> getInstances(String tenantServiceVersion, HttpUriRequest request, DWMatcher matcher) {
        List discoverInstances = null;
        if (!"default".equals(tenantServiceVersion)) {
            discoverInstances = this.discoveryClient.getInstances(this.serviceId).stream().filter(instance -> tenantServiceVersion.equals(instance.getMetadata().get("version"))).collect(Collectors.toList());
            log.info((Object)("DWTenantRoundLoadBalancer versionAble instance version : " + tenantServiceVersion + "  length :" + (CollectionUtils.isEmpty(discoverInstances) ? "0" : Integer.valueOf(discoverInstances.size()))));
            if (CollectionUtils.isEmpty(discoverInstances)) {
                return new ArrayList<ServiceInstance>();
            }
            discoverInstances = discoverInstances.stream().filter(instance -> this.instancePathMatch((ServiceInstance)instance, request, matcher, "dw-version-info", "path")).collect(Collectors.toList());
            log.info((Object)("DWTenantRoundLoadBalancer versionAble instance version : " + tenantServiceVersion + " after version path  length :" + (CollectionUtils.isEmpty(discoverInstances) ? "0" : Integer.valueOf(discoverInstances.size()))));
        }
        if (CollectionUtils.isEmpty(discoverInstances)) {
            discoverInstances = this.discoveryClient.getInstances(this.serviceId).stream().filter(instance -> this.instancePathMatch((ServiceInstance)instance, request, matcher, "api-info", "api-id") && !this.instancePathMatch((ServiceInstance)instance, request, matcher, "dw-version-info", "path")).collect(Collectors.toList());
        }
        return discoverInstances;
    }

    public boolean instancePathMatch(ServiceInstance serviceInstance, HttpUriRequest request, DWMatcher matcher, String prefix, String suffix) {
        String key;
        Map metadata = serviceInstance.getMetadata();
        int index = 0;
        while (metadata.containsKey(key = String.format(prefix + ".%d." + suffix, index))) {
            String pathRegex = (String)metadata.get(key);
            if (matcher.match(pathRegex, request)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private ServiceInstance selectInstance(List<ServiceInstance> serviceInstanceList, String tenantId) {
        if (CollectionUtils.isEmpty(serviceInstanceList)) {
            return null;
        }
        int pos = this.position.incrementAndGet() & Integer.MAX_VALUE;
        return serviceInstanceList.get(pos % serviceInstanceList.size());
    }

    private String getTentid() {
        return DWLoadBalanceRequestUtils.getTenantId();
    }

    private DWMatcher getMatcher(HttpUriRequest request) {
        return this.matchers.stream().filter(matcher -> matcher.canApply(request)).findFirst().get();
    }

    private Predicate<? super ServiceInstance> getpredicate() {
        return instance -> true;
    }

    public void onApplicationEvent(RegionSwitchEvent event) {
        if (event.getServiceName().equals(this.serviceId)) {
            this.servicePathCacheMap.clear();
        }
    }
}

