/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.autoconfigure;

import com.digiwin.app.service.eai.EAICallback;
import com.digiwin.app.service.eai.EAIService;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.loadbalance.scan.DWCommonScanner;
import com.digiwin.loadbalance.scan.candidate.DWEAIApiCandidate;
import com.digiwin.loadbalance.scan.candidate.DWResourceHelper;
import com.digiwin.loadbalance.scan.candidate.DWRestfulApiCandidate;
import com.digiwin.loadbalance.scan.candidate.DWStandardApiCandidate;
import com.digiwin.loadbalance.scan.candidate.VersionApiCandidate;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(name={"digiwin.load.balance.autoCongiguration.flage"}, matchIfMissing=false)
public class DWLoadBalancerScanningAutoConfiguration {
    @Bean
    DWRestfulApiCandidate dwRestfulApiCandidate() {
        return new DWRestfulApiCandidate();
    }

    @Bean
    @ConditionalOnClass(value={DWRestfulService.class})
    DWStandardApiCandidate dwStandardApiCandidate() {
        return new DWStandardApiCandidate();
    }

    @Bean
    @ConditionalOnClass(value={EAIService.class, EAICallback.class})
    @ConditionalOnProperty(value={"esp.register.enable"}, havingValue="true", matchIfMissing=true)
    DWEAIApiCandidate dweaiApiCandidate() {
        return new DWEAIApiCandidate();
    }

    @Bean
    DWCommonScanner dwCommonScanner(Environment environment, List<VersionApiCandidate> apiCandidates, DWResourceHelper dwResourceHelper) {
        return new DWCommonScanner(environment, apiCandidates, dwResourceHelper);
    }
}

