/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.event;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.registry.NacosRegistration;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.api.selector.NoneSelector;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.alibaba.nacos.client.naming.utils.UtilAndComs;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.loadbalance.discovery.DWDiscoveryProperties;
import com.digiwin.loadbalance.dto.SearchServiceResultDto;
import com.digiwin.loadbalance.scan.metadata.compress.DWAPiMetadata;
import com.digiwin.loadbalance.watch.ServiceMetadataReactor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.event.InstancePreRegisteredEvent;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class RegestionApplicationListener
implements ApplicationListener {
    private static Log log = LogFactory.getLog(RegestionApplicationListener.class);
    NamingProxy namingProxy;
    DWDiscoveryProperties dwDiscoveryProperties;
    NacosDiscoveryProperties nacosDiscoveryProperties;
    @Autowired
    ServiceMetadataReactor serviceMetadataReactor;
    private final ScheduledExecutorService executor;

    public RegestionApplicationListener(DWDiscoveryProperties dwDiscoveryProperties, NamingProxy namingProxy) {
        this.namingProxy = namingProxy;
        this.dwDiscoveryProperties = dwDiscoveryProperties;
        this.executor = new ScheduledThreadPoolExecutor(UtilAndComs.DEFAULT_POLLING_THREAD_COUNT, r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("com.digiwin.loadbalance.client.service.checker");
            return thread;
        });
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof InstancePreRegisteredEvent) {
            Registration registration = ((InstancePreRegisteredEvent)event).getRegistration();
            this.nacosDiscoveryProperties = ((NacosRegistration)registration).getNacosDiscoveryProperties();
        }
        if (event instanceof InstanceRegisteredEvent) {
            try {
                Service remoteService = this.namingProxy.queryService(this.nacosDiscoveryProperties.getService(), this.nacosDiscoveryProperties.getGroup());
                this.updateMetadata(remoteService);
                this.namingProxy.updateService(remoteService, (AbstractSelector)new NoneSelector());
            }
            catch (NacosException e) {
                log.error((Object)"update nacosServiceException error:", (Throwable)e);
            }
            this.serviceMetadataReactor.addServiceMetadataTask(this.dwDiscoveryProperties.getRegisterName());
        }
    }

    private void updateMetadata(Service remoteService) {
        String regx = "api-info." + this.dwDiscoveryProperties.getAppVersion() + "." + "\\d{1,}" + "." + "api-id";
        Map remoteServiceMetadata = remoteService.getMetadata();
        Set entries = remoteServiceMetadata.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((String)entry.getKey()).matches(regx)) continue;
            iterator.remove();
        }
        remoteServiceMetadata.putAll(this.createServiceMetadata());
    }

    private boolean checkServiceExist(NacosDiscoveryProperties nacosDiscoveryProperties) {
        List collect;
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("namespaceId", nacosDiscoveryProperties.getNamespace());
        params.put("groupName", nacosDiscoveryProperties.getGroup());
        params.put("expr", nacosDiscoveryProperties.getService());
        params.put("responsibleOnly", "true");
        String serviceSearch = null;
        try {
            serviceSearch = this.namingProxy.reqApi(UtilAndComs.nacosUrlService + "/names", params, "GET");
        }
        catch (NacosException e) {
            log.error((Object)("search service namespace:" + nacosDiscoveryProperties.getNamespace() + "group:" + nacosDiscoveryProperties.getGroup() + "service:" + nacosDiscoveryProperties.getService() + "error:"), (Throwable)e);
        }
        SearchServiceResultDto searchServiceResultDto = (SearchServiceResultDto)DWGsonProvider.getGson().fromJson(serviceSearch, SearchServiceResultDto.class);
        Map<String, String[]> serviceMap = searchServiceResultDto.getServices();
        if (null == serviceMap) {
            return false;
        }
        String[] nameSpaceServiceArray = serviceMap.get(this.namingProxy.getNamespaceId());
        return nameSpaceServiceArray != null && (collect = Arrays.stream(nameSpaceServiceArray).filter(groupServiceName -> {
            String[] groupServiceStr = groupServiceName.split("@@");
            if (groupServiceStr.length == 2) {
                return groupServiceStr[0].equals(nacosDiscoveryProperties.getGroup()) && groupServiceStr[1].equals(nacosDiscoveryProperties.getService());
            }
            return false;
        }).collect(Collectors.toList())).size() == 1;
    }

    private Service createLocalService(NacosDiscoveryProperties nacosDiscoveryProperties) {
        Service service = new Service();
        service.setGroupName(nacosDiscoveryProperties.getGroup());
        service.setName(nacosDiscoveryProperties.getService());
        service.setMetadata(this.createServiceMetadata());
        return service;
    }

    private Map<String, String> createServiceMetadata() {
        Set<DWAPiMetadata> eaiSetV2 = this.dwDiscoveryProperties.getEaiSetV2();
        Iterator<DWAPiMetadata> apiMetadataIterator = this.dwDiscoveryProperties.getEaiSetV2().iterator();
        HashMap<String, String> metadata = new HashMap<String, String>();
        while (apiMetadataIterator.hasNext()) {
            DWAPiMetadata apiMetadata = apiMetadataIterator.next();
            metadata.putIfAbsent(apiMetadata.getAPIid(), apiMetadata.getAPIid());
        }
        return metadata;
    }
}

