/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.esp;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import com.digiwin.loadbalance.loadbalancer.DWClientTenantRoundLoadBalancer;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class ESPServerNameCacheUtil {
    private static Log log = LogFactory.getLog(DWClientTenantRoundLoadBalancer.class);
    private static Set<String> appNameSet = new CopyOnWriteArraySet<String>();
    public static final String SPLITER = "@@";
    public static Cache<String, List<String>> eaiIdCache;
    public static Cache<String, String> unregistedCache;

    public static void initRegiestedCache(int inital, long max, long expireMillis) {
        eaiIdCache = CacheBuilder.newBuilder().initialCapacity(inital).maximumSize(max).expireAfterWrite(expireMillis, TimeUnit.MILLISECONDS).build();
    }

    public static void initUnRegiestedCache(int inital, long max, long expireMillis) {
        unregistedCache = CacheBuilder.newBuilder().initialCapacity(inital).maximumSize(max).expireAfterWrite(expireMillis, TimeUnit.MILLISECONDS).build();
    }

    public static String getServiceId(String serviceName, String proName) {
        return ESPServerNameCacheUtil.searchAppNameByEAIId(serviceName, proName);
    }

    public static boolean serviceMatchEaiId(Map<String, String> serviceMetadata, String eaiId) {
        if (CollectionUtils.isEmpty(serviceMetadata)) {
            return false;
        }
        Optional<Map.Entry> apiOptional = serviceMetadata.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(eaiId)).findAny();
        return apiOptional.isPresent();
    }

    public static boolean dapLoadRoute(String serviceName) {
        return ESPLoadBalanceUtil.getloadBalanceEnable() && StringUtils.isNotBlank((CharSequence)ESPServerNameCacheUtil.getServiceId(serviceName, null));
    }

    public static boolean dapLoadRoute(String serviceName, String proName) {
        return ESPLoadBalanceUtil.getloadBalanceEnable() && StringUtils.isNotBlank((CharSequence)ESPServerNameCacheUtil.getServiceId(serviceName, proName));
    }

    private static String searchAppNameByEAIId(String eaiId, String proName) {
        NacosDiscoveryProperties discoveryProperties = ESPLoadBalanceUtil.getDiscoveryProperties();
        NamingProxy namingProxy = ESPLoadBalanceUtil.getNamingProxy();
        if (StringUtils.isNotBlank((CharSequence)proName)) {
            block8: {
                try {
                    Service service = namingProxy.queryService(proName, discoveryProperties.getGroup());
                    if (ESPServerNameCacheUtil.serviceMatchEaiId(service.getMetadata(), eaiId)) {
                        return proName;
                    }
                    ESPServerNameCacheUtil.cacheUnregistedEaiId(proName, eaiId);
                }
                catch (NacosException e) {
                    log.error((Object)"query service metadata fail ", (Throwable)e);
                    if (404 != e.getErrCode()) break block8;
                    ESPServerNameCacheUtil.cacheUnregistedEaiId(proName, eaiId);
                }
            }
            return null;
        }
        List<String> nameList = null;
        Integer pageSize = 30;
        Integer pageNo = 1;
        AtomicBoolean cacheUnregisted = new AtomicBoolean(true);
        do {
            Optional<String> anyService;
            if (null == (nameList = ESPServerNameCacheUtil.getServiceList(pageNo, pageSize))) {
                cacheUnregisted.set(false);
            }
            if (!CollectionUtils.isEmpty(nameList) && (anyService = nameList.stream().filter(serviceName -> {
                try {
                    Service service = namingProxy.queryService(serviceName, discoveryProperties.getGroup());
                    return ESPServerNameCacheUtil.serviceMatchEaiId(service.getMetadata(), eaiId);
                }
                catch (NacosException e) {
                    log.error((Object)"query service metadata fail ", (Throwable)e);
                    if (404 != e.getErrCode()) {
                        cacheUnregisted.set(false);
                    }
                    return false;
                }
            }).findAny()).isPresent()) {
                return anyService.get();
            }
            Integer n = pageNo;
            Integer n2 = pageNo = Integer.valueOf(pageNo + 1);
        } while (!CollectionUtils.isEmpty(nameList));
        if (cacheUnregisted.get()) {
            ESPServerNameCacheUtil.cacheUnregistedEaiId(proName, eaiId);
        }
        return null;
    }

    private static String searchEAIIdServerSide(String eaiId, String appName) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("namespaceId", ESPLoadBalanceUtil.getDwDiscoveryProperties().getNamespace());
        params.put("groupName", ESPLoadBalanceUtil.getDwDiscoveryProperties().getGroup());
        params.put("eaiId", eaiId);
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            params.put("onlyServiceName", appName);
        }
        return ESPLoadBalanceUtil.getNamingProxy().reqApi("/search/searchEaiServiceName", params, "POST");
    }

    private static List<String> getServiceList(Integer pageNo, Integer pageSize) {
        NacosDiscoveryProperties discoveryProperties = ESPLoadBalanceUtil.getDiscoveryProperties();
        ListView serviceListView = null;
        try {
            serviceListView = ESPLoadBalanceUtil.getNamingProxy().getServiceList(pageNo.intValue(), pageSize.intValue(), discoveryProperties.getGroup());
        }
        catch (NacosException e) {
            log.error((Object)("get serviceListView fail namespace:" + discoveryProperties.getNamespace() + ",group:" + discoveryProperties.getGroup()), (Throwable)e);
            return null;
        }
        if (Objects.isNull(serviceListView) || CollectionUtils.isEmpty((Collection)serviceListView.getData())) {
            return new ArrayList<String>();
        }
        return serviceListView.getData();
    }

    public static String serarchEaiAppNameWithOrder(String eaiId, String proName) {
        if (StringUtils.isBlank((CharSequence)eaiId)) {
            throw new IllegalArgumentException("eaiId can't be empty");
        }
        if (ESPServerNameCacheUtil.isUnregisted(proName, eaiId)) {
            return null;
        }
        String searchedAppName = ESPServerNameCacheUtil.getFromCache(eaiId, proName);
        if (StringUtils.isNotBlank((CharSequence)searchedAppName)) {
            return searchedAppName;
        }
        try {
            searchedAppName = ESPServerNameCacheUtil.searchEAIIdServerSide(eaiId, proName);
        }
        catch (Exception e) {
            log.info((Object)("Exception when searchOnServerSide , eaiid" + eaiId + " ,appName"));
        }
        if (null == searchedAppName) {
            searchedAppName = ESPServerNameCacheUtil.getServiceId(eaiId, proName);
        }
        if (StringUtils.isNotBlank((CharSequence)searchedAppName)) {
            ESPServerNameCacheUtil.cacheEaiId(eaiId, searchedAppName);
            ESPServerNameCacheUtil.watchService(searchedAppName);
        }
        return searchedAppName;
    }

    private static String getFromCache(String eaiId, String proName) {
        List appNameList = (List)eaiIdCache.getIfPresent((Object)eaiId);
        if (CollectionUtils.isEmpty((Collection)appNameList)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)proName)) {
            if (appNameList.size() == 1) {
                return (String)appNameList.get(0);
            }
            return null;
        }
        if (appNameList.contains(proName)) {
            return proName;
        }
        return null;
    }

    private static void cacheEaiId(String eaiId, String proName) {
        CopyOnWriteArrayList<String> appNameList = (CopyOnWriteArrayList<String>)eaiIdCache.getIfPresent((Object)eaiId);
        if (CollectionUtils.isEmpty((Collection)appNameList) && StringUtils.isNotBlank((CharSequence)proName)) {
            appNameList = new CopyOnWriteArrayList<String>();
            appNameList.add(proName);
            eaiIdCache.put((Object)eaiId, appNameList);
        }
    }

    private static void watchService(String proName) {
        ESPLoadBalanceUtil.getServiceMetadataReactor().addServiceMetadataTask(proName);
        if (appNameSet.contains(proName)) {
            return;
        }
        try {
            appNameSet.add(proName);
            ESPLoadBalanceUtil.getNacosServerListWatcher().watch(proName, event -> {
                if (event instanceof NamingEvent) {
                    log.info((Object)("nacos NamingEvent ServiceName:" + ((NamingEvent)event).getServiceName() + ",clusters:" + ((NamingEvent)event).getClusters()));
                    String[] groupServiceName = ((NamingEvent)event).getServiceName().split(SPLITER);
                    String eventAppName = groupServiceName[groupServiceName.length - 1];
                    eaiIdCache.asMap().entrySet().stream().forEach(entry -> {
                        if (((String)entry.getKey()).equals(eventAppName)) {
                            eaiIdCache.invalidate(entry.getKey());
                        }
                    });
                }
            });
        }
        catch (NacosException e) {
            log.error((Object)("NacosException fail to find watch nacos serviceName:" + proName), (Throwable)e);
            appNameSet.remove(proName);
        }
    }

    private static boolean isUnregisted(String proName, String eaiId) {
        return null != unregistedCache.getIfPresent((Object)ESPServerNameCacheUtil.getUnCachekey(proName, eaiId));
    }

    private static void cacheUnregistedEaiId(String proName, String eaiId) {
        if (ESPLoadBalanceUtil.isCacheUnregisteredService()) {
            unregistedCache.put((Object)ESPServerNameCacheUtil.getUnCachekey(proName, eaiId), (Object)eaiId);
        }
    }

    public static String getUnCachekey(String proName, String eaiId) {
        return StringUtils.isBlank((CharSequence)proName) ? SPLITER + eaiId : proName + SPLITER + eaiId;
    }
}

