/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.scan.candidate;

import com.digiwin.loadbalance.scan.DWVersionable;
import com.digiwin.loadbalance.scan.candidate.AbstractVersionApiCandidate;
import com.digiwin.loadbalance.scan.candidate.DWTargetResource;
import com.digiwin.loadbalance.scan.metadata.ApiMetadata;
import com.digiwin.loadbalance.scan.metadata.CommonApiMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

public class ControllerApiCandidate
extends AbstractVersionApiCandidate {
    private Log log = LogFactory.getLog(ControllerApiCandidate.class);
    private String contextPath;
    private String[] pathAnnotationNameArrary = new String[]{GetMapping.class.getName(), PostMapping.class.getName(), PutMapping.class.getName(), DeleteMapping.class.getName(), RequestMapping.class.getName()};

    public ControllerApiCandidate(ServerProperties serverProperties) {
        this.contextPath = StringUtils.hasLength((String)serverProperties.getServlet().getContextPath()) ? serverProperties.getServlet().getContextPath() : "";
    }

    @Override
    public List<ApiMetadata> resolver(List<DWTargetResource> targetResourceList) throws IOException {
        ArrayList<ApiMetadata> metadataList = new ArrayList<ApiMetadata>();
        targetResourceList.stream().forEach(targetResource -> {
            for (Resource resource : targetResource.getResources()) {
                this.log.info((Object)("ControllerApiCandidate resource:" + resource + " begin"));
                List<Resource> jarFileClassResouces = null;
                try {
                    jarFileClassResouces = this.extractClass(resource);
                }
                catch (IOException e) {
                    this.log.error((Object)("extractClass faile  resource: " + resource.getDescription()), (Throwable)e);
                    continue;
                }
                for (Resource classResouce : jarFileClassResouces) {
                    MetadataReader metadataReader = null;
                    try {
                        InputStream inputStream = classResouce.getInputStream();
                        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                        ByteArrayResource classbytesResource = new ByteArrayResource((byte[])bytes.clone());
                        metadataReader = this.getMetadataReaderFactory().getMetadataReader((Resource)classbytesResource);
                        metadataList.addAll(this.resolverPathRegex(metadataReader, targetResource.getPrefix()));
                        inputStream.close();
                    }
                    catch (Throwable e) {
                        this.log.error((Object)("getMetadataReader faile resource:" + resource.getDescription() + "classResouce:" + resource.getDescription()), e);
                    }
                }
                this.closeResource();
                this.log.info((Object)("ControllerApiCandidate resource:" + resource + " end"));
            }
        });
        return metadataList;
    }

    @Override
    public List<ApiMetadata> resolverPathRegex(MetadataReader metadataReader, String prefix) {
        if (metadataReader.getAnnotationMetadata().hasAnnotation(RequestMapping.class.getName())) {
            ArrayList<ApiMetadata> apiMetadataList = new ArrayList<ApiMetadata>();
            Map requestMappingAttributes = metadataReader.getAnnotationMetadata().getAnnotationAttributes(RequestMapping.class.getName());
            String[] rootPathArray = (String[])requestMappingAttributes.get("path");
            if (metadataReader.getAnnotationMetadata().hasAnnotation(DWVersionable.class.getName())) {
                for (String rootPath : rootPathArray) {
                    String apiPth = this.contextPath + rootPath + "/**";
                    if (!apiPth.startsWith("/")) {
                        apiPth = "/" + apiPth;
                    }
                    apiMetadataList.add(new CommonApiMetadata(apiPth));
                }
                return apiMetadataList;
            }
            for (String annotationName : this.pathAnnotationNameArrary) {
                metadataReader.getAnnotationMetadata().getAnnotatedMethods(annotationName).stream().forEach(requestMethodMetadata -> {
                    Map handleAttributes = requestMethodMetadata.getAnnotationAttributes(annotationName);
                    String[] pathArray = null;
                    if (handleAttributes != null) {
                        pathArray = (String[])handleAttributes.get("path");
                        for (String rootPath : rootPathArray) {
                            for (String path : pathArray) {
                                String registerPath = this.contextPath + rootPath + "/" + path;
                                String string = registerPath = registerPath.endsWith("/") ? registerPath.substring(0, registerPath.length() - 1) : registerPath;
                                if (!registerPath.startsWith("/")) {
                                    registerPath = "/" + registerPath;
                                }
                                apiMetadataList.add(new CommonApiMetadata(registerPath, requestMethodMetadata.isAnnotated(DWVersionable.class.getName())));
                            }
                        }
                    }
                });
            }
            return apiMetadataList;
        }
        return new ArrayList<ApiMetadata>();
    }
}

