/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.event;

import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.digiwin.loadbalance.event.ServiceMetadataChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceMetadataChangeNotifier
extends Subscriber<ServiceMetadataChangeEvent> {
    private final Map<String, ConcurrentHashSet<EventListener>> listenerMap = new ConcurrentHashMap<String, ConcurrentHashSet<EventListener>>();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(String serviceName, String clusters, EventListener listener) {
        String key = ServiceInfo.getKey((String)serviceName, (String)clusters);
        ConcurrentHashSet eventListeners = this.listenerMap.get(key);
        if (eventListeners == null) {
            Object object = this.lock;
            synchronized (object) {
                eventListeners = this.listenerMap.get(key);
                if (eventListeners == null) {
                    eventListeners = new ConcurrentHashSet();
                    this.listenerMap.put(key, (ConcurrentHashSet<EventListener>)eventListeners);
                }
            }
        }
        eventListeners.add((Object)listener);
    }

    public void deregisterListener(String serviceName, String clusters, EventListener listener) {
        String key = ServiceInfo.getKey((String)serviceName, (String)clusters);
        ConcurrentHashSet<EventListener> eventListeners = this.listenerMap.get(key);
        if (eventListeners == null) {
            return;
        }
        eventListeners.remove((Object)listener);
        if (CollectionUtils.isEmpty(eventListeners)) {
            this.listenerMap.remove(key);
        }
    }

    public boolean isSubscribed(String serviceName, String clusters) {
        String key = ServiceInfo.getKey((String)serviceName, (String)clusters);
        ConcurrentHashSet<EventListener> eventListeners = this.listenerMap.get(key);
        return CollectionUtils.isNotEmpty(eventListeners);
    }

    public List<ServiceInfo> getSubscribeServices() {
        ArrayList<ServiceInfo> serviceInfos = new ArrayList<ServiceInfo>();
        for (String key : this.listenerMap.keySet()) {
            serviceInfos.add(ServiceInfo.fromKey((String)key));
        }
        return serviceInfos;
    }

    public void onEvent(ServiceMetadataChangeEvent event) {
    }

    public Class<? extends Event> subscribeType() {
        return ServiceMetadataChangeEvent.class;
    }
}

