/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.client.httpclient;

import com.digiwin.loadbalance.exception.DWAPIServiceNotFoundException;
import com.digiwin.loadbalance.exception.DWInstanceServiceNotFoundException;
import com.digiwin.loadbalance.exception.DWServiceNotFoundException;
import com.digiwin.loadbalance.exception.DWStateModeServiceNotFoundException;
import com.digiwin.loadbalance.exception.io.DWAPIServiceNotFoundIOException;
import com.digiwin.loadbalance.exception.io.DWInstanceServiceNotFoundIOException;
import com.digiwin.loadbalance.exception.io.DWServiceNotFoundIOException;
import com.digiwin.loadbalance.exception.io.DWStateModeServiceNotFoundIOException;
import com.digiwin.loadbalance.multiple.util.MutipleAppUtil;
import com.digiwin.loadbalance.namespace.DWLoadBalancerClientFactory;
import com.digiwin.loadbalance.properties.multiple.MultipleAPPProperties;
import com.digiwin.loadbalance.util.HttpRouteUtils;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.protocol.HttpContext;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.CollectionUtils;

public class DWMainExecWrapper
implements ClientExecChain {
    private Log log = LogFactory.getLog(this.getClass());
    private ClientExecChain requestExecutor;
    private final DWLoadBalancerClientFactory loadBalancerClientFactory;
    private boolean defaultModel;
    private final DiscoveryClient discoveryClient;
    private final MultipleAPPProperties multipleAPPProperties;

    public DWMainExecWrapper(DiscoveryClient discoveryClient, DWLoadBalancerClientFactory loadBalancerClientFactory, boolean defaultModel, MultipleAPPProperties multipleAPPProperties) {
        this.discoveryClient = discoveryClient;
        this.loadBalancerClientFactory = loadBalancerClientFactory;
        this.defaultModel = defaultModel;
        this.multipleAPPProperties = multipleAPPProperties;
    }

    public ClientExecChain wrapperProtocolExec(ClientExecChain requestExecutor) {
        this.requestExecutor = requestExecutor;
        return this;
    }

    private ServiceInstance serviceInstance(String serviceName) throws IOException {
        ServiceInstance serviceInstance;
        block3: {
            serviceInstance = null;
            try {
                if (this.defaultModel && CollectionUtils.isEmpty((Collection)this.getDiscoveryClient().getInstances(serviceName))) {
                    throw new DWServiceNotFoundIOException(HttpRouteUtils.INSTANCE_NOT_FOUND_ERROR_MESSAGE + serviceName);
                }
                serviceInstance = this.loadBalancerClientFactory.getInstance(serviceName).choose(serviceName);
            }
            catch (DWServiceNotFoundException e) {
                this.log.error((Object)("no service instance named:" + serviceName), (Throwable)((Object)e));
                if (!this.defaultModel) break block3;
                throw this.wrapperServiceNotFoundIOException(e);
            }
        }
        return serviceInstance;
    }

    private IOException wrapperServiceNotFoundIOException(DWServiceNotFoundException serviceNotFoundException) {
        if (serviceNotFoundException instanceof DWStateModeServiceNotFoundException) {
            return new DWStateModeServiceNotFoundIOException((Throwable)((Object)serviceNotFoundException));
        }
        if (serviceNotFoundException instanceof DWAPIServiceNotFoundException) {
            return new DWAPIServiceNotFoundIOException((Throwable)((Object)serviceNotFoundException));
        }
        if (serviceNotFoundException instanceof DWInstanceServiceNotFoundException) {
            return new DWInstanceServiceNotFoundIOException((Throwable)((Object)serviceNotFoundException));
        }
        return new DWServiceNotFoundIOException((Throwable)((Object)serviceNotFoundException));
    }

    public DiscoveryClient getDiscoveryClient() {
        return this.multipleAPPProperties.isMultipleApp() ? (DiscoveryClient)this.loadBalancerClientFactory.getInstance(MutipleAppUtil.getCurrentNameSpaceApp(), DiscoveryClient.class) : this.discoveryClient;
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext clientContext, HttpExecutionAware execAware) throws IOException, HttpException {
        String serviceName;
        ServiceInstance serviceInstance;
        if (HttpRouteUtils.needLoadbalance((HttpContext)clientContext) && null != (serviceInstance = this.serviceInstance(serviceName = HttpRouteUtils.getServiceName((HttpContext)clientContext)))) {
            return this.requestExecutor.execute(new HttpRoute(new HttpHost(serviceInstance.getHost(), serviceInstance.getPort())), request, clientContext, execAware);
        }
        RequestConfig originalRequestConfig = (RequestConfig)clientContext.getAttribute(HttpRouteUtils.ORIGINAL_REQUEST_CONFIG, RequestConfig.class);
        if (null != originalRequestConfig) {
            clientContext.setRequestConfig(originalRequestConfig);
        }
        return this.requestExecutor.execute(route, request, clientContext, execAware);
    }
}

