/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.autoconfigure.common;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.digiwin.loadbalance.client.autoconfigure.DWClientLoadBalancerAutoConfiguration;
import com.digiwin.loadbalance.client.httpclient.DWAttemptHttpLoadbalanceRoute;
import com.digiwin.loadbalance.client.httpclient.DWDefaultHttpLoadbalanceRoute;
import com.digiwin.loadbalance.client.httpclient.DWDefaultMainExecWrapperFactory;
import com.digiwin.loadbalance.client.httpclient.DWMainExecWrapperFactory;
import com.digiwin.loadbalance.client.httpclient.autoconfigure.HttpClientAutoConfigure;
import com.digiwin.loadbalance.client.httpclient.reroute.DWAttemptReRoutePlanner;
import com.digiwin.loadbalance.client.httpclient.reroute.DWDefaultReRoutePlanner;
import com.digiwin.loadbalance.config.request.LoadbalanceRequestConfig;
import com.digiwin.loadbalance.discovery.DWDiscoveryProperties;
import com.digiwin.loadbalance.esp.DWEAIPropertiesBean;
import com.digiwin.loadbalance.esp.ESPExecutorPoolProperties;
import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import com.digiwin.loadbalance.esp.ESPServerNameCacheUtil;
import com.digiwin.loadbalance.matcher.DWMatcher;
import com.digiwin.loadbalance.matcher.UrlPathMatcher;
import com.digiwin.loadbalance.matcher.delegate.DWMatcherDelegate;
import com.digiwin.loadbalance.matcher.delegate.UrlPathMatcherDelegate;
import com.digiwin.loadbalance.matcher.v2.DWMatcherV2;
import com.digiwin.loadbalance.matcher.v2.UrlPathMatcherV2;
import com.digiwin.loadbalance.namespace.DWLoadBalancerClientFactory;
import com.digiwin.loadbalance.properties.auth.AuthenProperties;
import com.digiwin.loadbalance.properties.cache.DWCacheProperties;
import com.digiwin.loadbalance.properties.multiple.MultipleAPPProperties;
import com.digiwin.loadbalance.service.TenantIdService;
import com.digiwin.loadbalance.watch.NacosServerListWatcher;
import com.digiwin.loadbalance.watch.ServiceMetadataReactor;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureAfter(value={DWClientLoadBalancerAutoConfiguration.class})
@ConditionalOnProperty(name={"digiwin.load.balance.autoCongiguration.flage"}, matchIfMissing=false)
@ImportAutoConfiguration(value={HttpClientAutoConfigure.class})
public class DWLoadBalanceAutoconfiguration {
    @Bean
    MultipleAPPProperties multipleAPPProperties() {
        return new MultipleAPPProperties();
    }

    @Bean
    AuthenProperties autheProperties() {
        return new AuthenProperties();
    }

    @Bean
    DWCacheProperties dwCacheProperties() {
        return new DWCacheProperties();
    }

    @Bean
    ESPExecutorPoolProperties espExecutorPoolProperties() {
        return new ESPExecutorPoolProperties();
    }

    @Bean
    public ESPLoadBalanceUtil init(DiscoveryClient discoveryClient, @Qualifier(value="dwDefaultHttpLoadbalanceRoute") HttpRoutePlanner dwRoutePlanner, ObjectProvider<NacosServerListWatcher> nacosServerListWatcher, Environment environment, ObjectProvider<NacosDiscoveryProperties> nacosDiscoveryProperties, ESPExecutorPoolProperties espExecutorPoolProperties, ObjectProvider<NamingProxy> namingProxy, ObjectProvider<DWEAIPropertiesBean> eaiPropertiesProvider, ObjectProvider<DWDiscoveryProperties> dwDiscoveryProperties, ObjectProvider<ServiceMetadataReactor> serviceMetadataReactor, TenantIdService tenantIdService, @Qualifier(value="dwDefaultReRoutePlanner") HttpRoutePlanner dwDefaultReRoutePlanner, @Qualifier(value="dwDefaultMainExecWrapperFactory") DWMainExecWrapperFactory dwMainExecWrapperFactory, DWCacheProperties dwCacheProperties) {
        ESPServerNameCacheUtil.initAnonymousCache(dwCacheProperties.getMdc_prod_name_cache_inital(), dwCacheProperties.getMdc_prod_name_cache_max(), dwCacheProperties.getMdc_prod_name_cache_millis());
        ESPServerNameCacheUtil.initRegiestedCache(dwCacheProperties.getEai_registed_cache_inital(), dwCacheProperties.getEai_registed_cache_max(), dwCacheProperties.getEai_registed_cache_millis());
        ESPServerNameCacheUtil.initUnRegiestedCache(dwCacheProperties.getEai_unregisted_cache_inital(), dwCacheProperties.getEai_unregisted_cache_max(), dwCacheProperties.getEai_unregisted_cache_millis());
        ESPLoadBalanceUtil espLoadBalanceUtil = new ESPLoadBalanceUtil();
        ESPLoadBalanceUtil.setCacheAnonymous(dwCacheProperties.isAnonymousCache());
        String dwloadBalanceEnable = environment.getProperty("dwloadBalanceEnable");
        String esploadBalanceEnable = environment.getProperty("esp.loadbalance.enable");
        String cacheUnregisteredService = environment.getProperty("esp.cache.unregistered.service");
        if ("false".equalsIgnoreCase(cacheUnregisteredService)) {
            ESPLoadBalanceUtil.setCacheUnregisteredService(false);
        }
        if ("true".equalsIgnoreCase(dwloadBalanceEnable) && !"false".equalsIgnoreCase(esploadBalanceEnable)) {
            ESPLoadBalanceUtil.setLoadBalanceEnable(true);
        } else {
            ESPLoadBalanceUtil.setLoadBalanceEnable(false);
        }
        ESPLoadBalanceUtil.setDiscoveryClient(discoveryClient);
        ESPLoadBalanceUtil.setDwRoutePlanner(dwRoutePlanner);
        ESPLoadBalanceUtil.setNacosServerListWatcher((NacosServerListWatcher)nacosServerListWatcher.getIfAvailable());
        ESPLoadBalanceUtil.setDiscoveryProperties((NacosDiscoveryProperties)nacosDiscoveryProperties.getIfAvailable());
        ESPLoadBalanceUtil.setEspExecutorPoolProperties(espExecutorPoolProperties);
        ESPLoadBalanceUtil.setNamingProxy((NamingProxy)namingProxy.getIfAvailable());
        ESPLoadBalanceUtil.setDwDiscoveryProperties((DWDiscoveryProperties)dwDiscoveryProperties.getIfAvailable());
        ESPLoadBalanceUtil.setServiceMetadataReactor((ServiceMetadataReactor)serviceMetadataReactor.getIfAvailable());
        ESPLoadBalanceUtil.setTenantIdService(tenantIdService);
        DWEAIPropertiesBean eaiProperties = (DWEAIPropertiesBean)eaiPropertiesProvider.getIfAvailable();
        if (null != eaiProperties) {
            if (StringUtils.isNumeric((CharSequence)eaiProperties.getHostRetryInterval())) {
                ESPLoadBalanceUtil.setEaiHostRetryInterval(Integer.valueOf(eaiProperties.getHostRetryInterval()));
            }
            if (StringUtils.isNumeric((CharSequence)eaiProperties.getHostRetryTimes())) {
                ESPLoadBalanceUtil.setEaiHostRetryTimes(Integer.valueOf(eaiProperties.getHostRetryTimes()));
            }
            ESPLoadBalanceUtil.setEaiRestfulPath(eaiProperties.getRestfulServicePath());
            ESPLoadBalanceUtil.setEaiCallbackPath(eaiProperties.getRestfulServiceCallbackPath());
        }
        ESPLoadBalanceUtil.setDwMainExecWrapperFactory(dwMainExecWrapperFactory);
        ESPLoadBalanceUtil.setDwRerouteRoutePlanner(dwDefaultReRoutePlanner);
        return espLoadBalanceUtil;
    }

    @ConditionalOnClass(value={HttpClient.class})
    @Bean(value={"dwDefaultHttpLoadbalanceRoute"})
    HttpRoutePlanner dwHttpLoadbalanceRoute(DWLoadBalancerClientFactory loadBalancerClientFactory, AuthenProperties authenProperties, TenantIdService tenantIdService, DiscoveryClient discoveryClient, MultipleAPPProperties multipleAPPProperties, LoadbalanceRequestConfig loadbalanceRequestConfig) {
        return new DWDefaultHttpLoadbalanceRoute(authenProperties, loadBalancerClientFactory, tenantIdService, discoveryClient, multipleAPPProperties, loadbalanceRequestConfig);
    }

    @ConditionalOnClass(value={HttpClient.class})
    @Bean(value={"dwAttemptHttpLoadbalanceRoute"})
    @ConditionalOnProperty(name={"dwhttpClient.loadbalance.mode"}, havingValue="auto")
    HttpRoutePlanner dwAttemptHttpLoadbalanceRoute(DWLoadBalancerClientFactory loadBalancerClientFactory, AuthenProperties authenProperties, TenantIdService tenantIdService, DiscoveryClient discoveryClient, MultipleAPPProperties multipleAPPProperties, LoadbalanceRequestConfig loadbalanceRequestConfig) {
        return new DWAttemptHttpLoadbalanceRoute(authenProperties, loadBalancerClientFactory, tenantIdService, discoveryClient, multipleAPPProperties, loadbalanceRequestConfig);
    }

    @ConditionalOnClass(value={HttpClient.class})
    @Bean(value={"dwDefaultReRoutePlanner"})
    HttpRoutePlanner dwDefaultReRoutePlanner(DWLoadBalancerClientFactory loadBalancerClientFactory, AuthenProperties authenProperties, TenantIdService tenantIdService, DiscoveryClient discoveryClient, MultipleAPPProperties multipleAPPProperties, LoadbalanceRequestConfig loadbalanceRequestConfig) {
        return new DWDefaultReRoutePlanner(authenProperties, loadBalancerClientFactory, tenantIdService, discoveryClient, multipleAPPProperties, loadbalanceRequestConfig);
    }

    @ConditionalOnClass(value={HttpClient.class})
    @Bean(value={"dwAttemptReRoutePlanner"})
    @ConditionalOnProperty(name={"dwhttpClient.loadbalance.mode"}, havingValue="auto")
    HttpRoutePlanner dwWAttemptReRoutePlanner(DWLoadBalancerClientFactory loadBalancerClientFactory, AuthenProperties authenProperties, TenantIdService tenantIdService, DiscoveryClient discoveryClient, MultipleAPPProperties multipleAPPProperties, LoadbalanceRequestConfig loadbalanceRequestConfig) {
        return new DWAttemptReRoutePlanner(authenProperties, loadBalancerClientFactory, tenantIdService, discoveryClient, multipleAPPProperties, loadbalanceRequestConfig);
    }

    @Bean
    DWMatcher urlPathMatcher() {
        return new UrlPathMatcher();
    }

    @Bean
    DWMatcherV2 urlPathMatcherV2() {
        return new UrlPathMatcherV2();
    }

    @Bean
    @DependsOn(value={"urlPathMatcherV2", "urlPathMatcher"})
    DWMatcherDelegate urlPathMatcherDelegate() {
        return new UrlPathMatcherDelegate();
    }

    @Bean(value={"dwDefaultMainExecWrapperFactory"})
    @ConditionalOnClass(value={HttpClient.class})
    DWMainExecWrapperFactory dwDefaultMainExecWrapperFactory(DiscoveryClient discoveryClient, DWLoadBalancerClientFactory loadBalancerClientFactory, Environment environment) {
        return new DWDefaultMainExecWrapperFactory(discoveryClient, loadBalancerClientFactory, !"auto".equalsIgnoreCase(environment.getProperty("dwhttpClient.loadbalance.mode")));
    }

    @Bean
    LoadbalanceRequestConfig loadbalanceRequestConfig(Environment environment) {
        String requestPropertyPrefix = environment.getProperty("dap.http.client.config.prefix", "dw") + "HttpRequestConfig";
        int connectionRequestTimeout = (Integer)environment.getProperty(requestPropertyPrefix + "ConnectionRequestTimeout", Integer.class, (Object)120000);
        int connectTimeout = (Integer)environment.getProperty(requestPropertyPrefix + "ConnectTimeout", Integer.class, (Object)120000);
        int socketTimeout = (Integer)environment.getProperty(requestPropertyPrefix + "SocketTimeout", Integer.class, (Object)120000);
        long requestSize = (Long)environment.getProperty(requestPropertyPrefix + "RequestSize", Long.class, (Object)0xA00000L);
        int connectionRequestTimeoutLimit = (Integer)environment.getProperty(requestPropertyPrefix + "ConnectionRequestTimeoutLimit", Integer.class, (Object)120000);
        int connectTimeoutLimit = (Integer)environment.getProperty(requestPropertyPrefix + "ConnectTimeoutLimit", Integer.class, (Object)120000);
        int socketTimeoutLimit = (Integer)environment.getProperty(requestPropertyPrefix + "SocketTimeoutLimit", Integer.class, (Object)120000);
        boolean enableRequestSizeLimit = (Boolean)environment.getProperty(requestPropertyPrefix + "RequestSizeLimit", Boolean.class, (Object)false);
        return new LoadbalanceRequestConfig(connectionRequestTimeout, connectTimeout, socketTimeout, connectionRequestTimeoutLimit > 0 ? connectionRequestTimeoutLimit : 120000, connectTimeoutLimit > 0 ? connectTimeoutLimit : 120000, socketTimeoutLimit > 0 ? socketTimeoutLimit : 120000, requestSize, enableRequestSizeLimit);
    }
}

