/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.scan.candidate;

import com.digiwin.loadbalance.scan.candidate.DWAbstractResourceHelper;
import com.digiwin.loadbalance.scan.candidate.DWTargetResource;
import com.digiwin.resource.simplified.DWSimplifiedGroupLocationInfo;
import com.digiwin.resource.simplified.utils.DWSimplifiedResourceUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DWGroupResourceHelper
extends DWAbstractResourceHelper {
    ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private Log log = LogFactory.getLog(DWGroupResourceHelper.class);
    static final String DEFAULT_RESOURCE_PATTERN = "**/*.class";
    static final String GROUPINFO_RESOURCE_PATTERN = "META-INF/dap.info";

    @Override
    public List<DWTargetResource> getDWTargetResource(Environment environment) {
        ArrayList<GroupResource> groupResourceList = new ArrayList<GroupResource>();
        try {
            Resource[] groupInfoResouces = this.resourcePatternResolver.getResources("classpath*:META-INF/dap.info");
            for (Resource gourpResouce : groupInfoResouces) {
                String groupPath = gourpResouce.getURL().toString();
                String groupRoot = groupPath.substring(0, groupPath.length() - GROUPINFO_RESOURCE_PATTERN.length());
                String classPattern = groupRoot + DEFAULT_RESOURCE_PATTERN;
                Properties dapInfoProperties = new Properties();
                dapInfoProperties.load(gourpResouce.getInputStream());
                DWSimplifiedGroupLocationInfo groupInfo = DWSimplifiedResourceUtils.createGroupInfo((Properties)dapInfoProperties);
                Resource[] classResources = this.resourcePatternResolver.getResources(classPattern);
                if (null == groupInfo) continue;
                groupResourceList.add(new GroupResource(groupInfo, classResources));
            }
        }
        catch (Throwable e) {
            this.log.error((Object)"read resource file fail {} ", e);
        }
        List classPathScanList = (List)environment.getProperty("digiwin.service.path.version.scan.packages", List.class);
        if (!CollectionUtils.isEmpty((Collection)classPathScanList)) {
            for (String path : classPathScanList) {
                try {
                    String basePath = ClassUtils.convertClassNameToResourcePath((String)environment.resolveRequiredPlaceholders(path));
                    Resource[] resources = this.resourcePatternResolver.getResources("classpath*:" + basePath + DEFAULT_RESOURCE_PATTERN);
                    groupResourceList.add(new GroupResource(null, resources));
                }
                catch (IOException e) {
                    this.log.error((Object)("get class path resource fail path:" + path), (Throwable)e);
                }
            }
        }
        return groupResourceList.stream().sorted((o1, o2) -> {
            int o1Layer = o1.getGroupInfo() == null || !StringUtils.hasText((String)o1.getGroupInfo().getName()) ? Integer.MIN_VALUE : o1.getGroupInfo().getBusinessLayer();
            int o2Layer = o2.getGroupInfo() == null || !StringUtils.hasText((String)o2.getGroupInfo().getName()) ? Integer.MIN_VALUE : o2.getGroupInfo().getBusinessLayer();
            return Integer.compare(o1Layer, o2Layer);
        }).map(groupResource -> {
            if (null != groupResource.getGroupInfo() && StringUtils.hasText((String)groupResource.getGroupInfo().getName())) {
                return new DWTargetResource(groupResource.getGroupInfo().getName(), groupResource.getResources());
            }
            return new DWTargetResource(null, groupResource.getResources());
        }).collect(Collectors.toList());
    }

    private class GroupResource {
        private DWSimplifiedGroupLocationInfo groupInfo;
        private Resource[] resources;

        public GroupResource(DWSimplifiedGroupLocationInfo groupInfo, Resource[] resources) {
            this.groupInfo = groupInfo;
            this.resources = resources;
        }

        public DWSimplifiedGroupLocationInfo getGroupInfo() {
            return this.groupInfo;
        }

        public void setGroupInfo(DWSimplifiedGroupLocationInfo groupInfo) {
            this.groupInfo = groupInfo;
        }

        public Resource[] getResources() {
            return this.resources;
        }

        public void setResources(Resource[] resources) {
            this.resources = resources;
        }
    }
}

