/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.scan.candidate.v2;

import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.loadbalance.scan.DWVersionable;
import com.digiwin.loadbalance.scan.candidate.v2.AbstractApiCandidateV2;
import com.digiwin.loadbalance.scan.metadata.compress.DWCommonApiMetadata;
import com.digiwin.loadbalance.util.APITagUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class DWStandardApiCandidateV2
extends AbstractApiCandidateV2<DWCommonApiMetadata> {
    @Override
    public List<DWCommonApiMetadata> resolverPathRegex(MetadataReader classMetadataReader, String rootPath) {
        ArrayList<DWCommonApiMetadata> apiMetadataList = new ArrayList<DWCommonApiMetadata>();
        if (classMetadataReader.getClassMetadata().isInterface() && classMetadataReader.getAnnotationMetadata().hasAnnotation(DWRestfulService.class.getName()) && Arrays.stream(classMetadataReader.getClassMetadata().getInterfaceNames()).filter(interfaceName -> DWService.class.getName().equals(interfaceName)).findAny().isPresent()) {
            String classRequestPath = "";
            if (classMetadataReader.getAnnotationMetadata().hasAnnotation(DWRequestMapping.class.getName())) {
                Map classrequestMappingAttributes = classMetadataReader.getAnnotationMetadata().getAnnotationAttributes(DWRequestMapping.class.getName());
                classRequestPath = classrequestMappingAttributes.get("path").toString();
            }
            boolean classVersionAble = classMetadataReader.getAnnotationMetadata().hasAnnotation(DWVersionable.class.getName());
            Set annotatedMethods = classMetadataReader.getAnnotationMetadata().getAnnotatedMethods(DWRequestMapping.class.getName());
            for (MethodMetadata methodMetadata : annotatedMethods) {
                Map methodAttributes = methodMetadata.getAnnotationAttributes(DWRequestMapping.class.getName());
                String methodPath = methodAttributes.get("path").toString();
                UriComponents uriComponents = UriComponentsBuilder.newInstance().path("/").path(rootPath).path("/").path(classRequestPath).path("/").path(methodPath).build();
                DWRequestMethod[] dwRequestMethods = (DWRequestMethod[])methodAttributes.get("method");
                int[] tags = this.getTags(this.switchRequestMethod(dwRequestMethods), this.appVersionAble() && (this.allVersionAble() || classVersionAble || methodMetadata.isAnnotated(DWVersionable.class.getName())));
                apiMetadataList.add(new DWCommonApiMetadata(uriComponents.getPath(), tags));
            }
        }
        return apiMetadataList;
    }

    private Set<RequestMethod> switchRequestMethod(DWRequestMethod ... dwRequestMethods) {
        HashSet<RequestMethod> requestMethodSet = new HashSet<RequestMethod>();
        for (DWRequestMethod dwRequestMethod : dwRequestMethods) {
            requestMethodSet.add(APITagUtils.switchMethod(dwRequestMethod));
        }
        return requestMethodSet;
    }

    @Override
    public int[] processBaseTages(int[] baseTags) {
        if (ArrayUtils.isEmpty((int[])baseTags)) {
            throw new IllegalArgumentException("tags must not be empty");
        }
        int baseTag = baseTags[0];
        baseTags[0] = baseTag += 2;
        return baseTags;
    }
}

