/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.task.service;

import com.alibaba.nacos.client.naming.utils.UtilAndComs;
import com.digiwin.loadbalance.task.DigiwinAbstractTaskExecuteEngine;
import com.digiwin.loadbalance.task.DigiwinDelayTask;
import com.digiwin.loadbalance.task.DigiwinTaskProcessor;
import com.digiwin.loadbalance.util.ServiceMetadataUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceMetadataTaskExecuteEngine
extends DigiwinAbstractTaskExecuteEngine<DigiwinDelayTask> {
    private static Log log = LogFactory.getLog(ServiceMetadataTaskExecuteEngine.class);
    protected final ConcurrentHashMap<Object, DigiwinDelayTask> tasks;
    private final ScheduledExecutorService executor;
    protected final ReentrantLock lock = new ReentrantLock();

    public ServiceMetadataTaskExecuteEngine() {
        this.tasks = new ConcurrentHashMap();
        this.executor = new ScheduledThreadPoolExecutor(UtilAndComs.DEFAULT_POLLING_THREAD_COUNT, r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("com.digiwin.loadbalance.client.service.checker");
            return thread;
        });
        this.executor.schedule(new ProcessRunnable(), ServiceMetadataUtils.SERVICE_METADATA_DEFAULT_DELAY, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTask(Object key, DigiwinDelayTask newTask) {
        this.lock.lock();
        try {
            DigiwinDelayTask existTask = this.tasks.get(key);
            if (null != existTask) {
                newTask.merge(existTask);
            }
            this.tasks.put(key, newTask);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DigiwinDelayTask removeTask(Object key) {
        this.lock.lock();
        try {
            DigiwinDelayTask task = this.tasks.get(key);
            if (null != task) {
                DigiwinDelayTask digiwinDelayTask = this.tasks.remove(key);
                return digiwinDelayTask;
            }
            DigiwinDelayTask digiwinDelayTask = null;
            return digiwinDelayTask;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Collection<Object> getAllTaskKeys() {
        HashSet<Object> keys = new HashSet<Object>();
        this.lock.lock();
        try {
            keys.addAll(this.tasks.keySet());
        }
        finally {
            this.lock.unlock();
        }
        return keys;
    }

    protected void processTasks() {
        Collection<Object> keys = this.getAllTaskKeys();
        for (Object taskKey : keys) {
            DigiwinDelayTask task = this.removeTask(taskKey);
            if (null == task) continue;
            DigiwinTaskProcessor processor = this.getProcessor(taskKey);
            if (null == processor) {
                log.error((Object)("processor not found for task, so discarded. " + String.valueOf(task)));
                continue;
            }
            try {
                if (processor.process(task)) continue;
                this.retryFailedTask(taskKey, task);
            }
            catch (Throwable e) {
                log.error((Object)"digiwin task execute error ", e);
                this.retryFailedTask(taskKey, task);
            }
        }
    }

    private void retryFailedTask(Object key, DigiwinDelayTask task) {
        this.addTask(key, task);
    }

    private class ProcessRunnable
    implements Runnable {
        private ProcessRunnable() {
        }

        @Override
        public void run() {
            try {
                ServiceMetadataTaskExecuteEngine.this.processTasks();
            }
            catch (Throwable e) {
                log.error((Object)e.toString(), e);
            }
        }
    }
}

