/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.autoconfigure;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.nacos.registry.NacosRegistrationCustomizer;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.client.naming.remote.NamingClientProxy;
import com.alibaba.nacos.client.naming.remote.NamingClientProxyDelegate;
import com.alibaba.nacos.client.naming.remote.http.NamingHttpClientProxy;
import com.digiwin.loadbalance.client.autoconfigure.DWClientLoadBalancerAutoConfiguration;
import com.digiwin.loadbalance.client.httpclient.DWDefaultHttpLoadbalanceRoute;
import com.digiwin.loadbalance.discovery.DWDiscoveryProperties;
import com.digiwin.loadbalance.esp.DWEAIPropertiesBean;
import com.digiwin.loadbalance.esp.ESPExecutorPoolProperties;
import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import com.digiwin.loadbalance.event.RegestionApplicationListener;
import com.digiwin.loadbalance.scan.DWCommonScanner;
import com.digiwin.loadbalance.scan.candidate.DWResourceHelper;
import com.digiwin.loadbalance.scan.candidate.DWTargetResource;
import com.digiwin.loadbalance.scan.metadata.ApiMetadata;
import com.digiwin.loadbalance.scan.metadata.compress.DWAPiMetadata;
import com.digiwin.loadbalance.scan.v2.DWCommonScannerV2;
import com.digiwin.loadbalance.service.TenantIdService;
import com.digiwin.loadbalance.util.DWInstanceUtils;
import com.digiwin.loadbalance.watch.NacosServerListWatcher;
import com.digiwin.loadbalance.watch.ServiceMetadataReactor;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureAfter(value={DWClientLoadBalancerAutoConfiguration.class})
@ConditionalOnProperty(name={"digiwin.load.balance.autoCongiguration.flage"}, matchIfMissing=false)
public class DWLoadBalancerAutoConfiguration {
    private static Log log = LogFactory.getLog(DWLoadBalancerAutoConfiguration.class);

    @Bean
    DWDiscoveryProperties dwDiscoveryProperties(Environment environment, DWCommonScanner dwCommonScanner, DWCommonScannerV2 dwCommonScannerV2, DWResourceHelper resourceHelper) throws Exception {
        List<DWTargetResource> dwTargetResourceList = resourceHelper.getDWTargetResource(environment);
        DWDiscoveryProperties dwDiscoveryProperties = new DWDiscoveryProperties();
        dwDiscoveryProperties.setApiSet(dwCommonScanner.scan(dwTargetResourceList));
        dwDiscoveryProperties.setApiSetV2(dwCommonScannerV2.scan(dwTargetResourceList));
        dwDiscoveryProperties.initEaiApiSet();
        return dwDiscoveryProperties;
    }

    @Bean
    public NacosServerListWatcher nacosServerListWatcher(Environment environment, NacosServiceManager nacosServiceManager, NacosDiscoveryProperties nacosDiscoveryProperties) {
        return new NacosServerListWatcher(nacosServiceManager, nacosDiscoveryProperties);
    }

    @Bean
    public NacosRegistrationCustomizer nacosRegistrationCustomizer(DWDiscoveryProperties dwDiscoveryProperties, ObjectProvider<DWEAIPropertiesBean> eaiPropertiesProvider, Environment environment) {
        log.debug((Object)("DWDiscoveryProperties:" + String.valueOf(dwDiscoveryProperties) + " Environment properties name:dwallVersionAble  , value:" + environment.getProperty("dwallVersionAble")));
        return nacosRegistration -> {
            boolean defaultVersionFlag = "default".equals(dwDiscoveryProperties.getAppVersion());
            DWEAIPropertiesBean eaiProperties = (DWEAIPropertiesBean)eaiPropertiesProvider.getIfAvailable();
            Map metadata = nacosRegistration.getMetadata();
            this.resetDiscoverProperty(nacosRegistration.getNacosDiscoveryProperties(), dwDiscoveryProperties);
            boolean allVersionAble = "true".equalsIgnoreCase(dwDiscoveryProperties.getAllVersionAble());
            Iterator<ApiMetadata> apiMetadataIterator = dwDiscoveryProperties.getApiSet().iterator();
            int versionAbleIndex = 0;
            int apiIndex = 0;
            while (apiMetadataIterator.hasNext()) {
                ApiMetadata apiMetadata = apiMetadataIterator.next();
                log.debug((Object)("api collector by dap index:" + apiIndex + ",apiid:" + apiMetadata.getAPIid()));
                metadata.put("api-info." + apiIndex + ".api-id", apiMetadata.getInstanceMatchId());
                ++apiIndex;
                if (defaultVersionFlag || !apiMetadata.getVersionAble() && !allVersionAble) continue;
                metadata.put("dw-version-info." + versionAbleIndex + ".path", apiMetadata.getVersionAbleId());
                ++versionAbleIndex;
            }
            if (null != eaiProperties) {
                if (StringUtils.isNotBlank((CharSequence)eaiProperties.getRestfulServicePath())) {
                    metadata.put("api-info." + apiIndex + ".api-id", eaiProperties.getRestfulServicePath());
                    ++apiIndex;
                }
                if (StringUtils.isNotBlank((CharSequence)eaiProperties.getRestfulServiceCallbackPath())) {
                    metadata.put("api-info." + apiIndex + ".api-id", eaiProperties.getRestfulServiceCallbackPath());
                }
            }
            int apiIndexV2 = 0;
            for (DWAPiMetadata apiV2 : dwDiscoveryProperties.getApiSetV2()) {
                metadata.put("dwapi." + apiIndexV2, apiV2.getInstanceApi());
                ++apiIndexV2;
            }
            String imageName = System.getenv("APPIMAGENAME");
            String region = System.getenv("STATEMODE");
            if (StringUtils.isNotBlank((CharSequence)imageName) && StringUtils.isNotBlank((CharSequence)region)) {
                metadata.put("APPIMAGENAME", imageName);
                metadata.put("STATEMODE", region);
            }
            this.registerEAI(metadata, eaiPropertiesProvider);
            metadata.put("version", StringUtils.isNotBlank((CharSequence)dwDiscoveryProperties.getAppVersion()) ? dwDiscoveryProperties.getAppVersion() : "default");
            metadata.put("describe", dwDiscoveryProperties.getDwappDescribe());
            String loadbalanceVersion = DWLoadBalancerAutoConfiguration.class.getPackage().getImplementationVersion();
            if (StringUtils.isBlank((CharSequence)loadbalanceVersion) && StringUtils.isBlank((CharSequence)(loadbalanceVersion = environment.getProperty("loadbalance_version")))) {
                throw new RuntimeException("can't get loadbalance version please check and specify loadbalance version");
            }
            DWInstanceUtils.CURRENT_VERSION = loadbalanceVersion;
            metadata.put("loadbalance_version", loadbalanceVersion);
            metadata.put("server_context_path", dwDiscoveryProperties.getContextPath());
            metadata.put("supportApiCompress", "true");
        };
    }

    private void resetDiscoverProperty(NacosDiscoveryProperties nacosDiscoveryProperties, DWDiscoveryProperties dwDiscoveryProperties) {
        String serviceName = Objects.nonNull(dwDiscoveryProperties.getAppid()) ? dwDiscoveryProperties.getAppid() : dwDiscoveryProperties.getSpringApplicationName();
        nacosDiscoveryProperties.setService(serviceName.split("_")[0]);
        if (StringUtils.isNumeric((CharSequence)dwDiscoveryProperties.getPort())) {
            nacosDiscoveryProperties.setPort(Integer.valueOf(dwDiscoveryProperties.getPort()).intValue());
        }
        if (StringUtils.isNotBlank((CharSequence)dwDiscoveryProperties.getIp())) {
            nacosDiscoveryProperties.setIp(dwDiscoveryProperties.getIp());
        }
        if (StringUtils.isNumeric((CharSequence)dwDiscoveryProperties.getWatchDelay())) {
            nacosDiscoveryProperties.setWatchDelay(Long.valueOf(dwDiscoveryProperties.getWatchDelay()).longValue());
        }
        nacosDiscoveryProperties.setUsername(dwDiscoveryProperties.getUsername());
        nacosDiscoveryProperties.setPassword(dwDiscoveryProperties.getPassword());
        nacosDiscoveryProperties.setClusterName(dwDiscoveryProperties.getClusterName());
        nacosDiscoveryProperties.setNamespace(dwDiscoveryProperties.getNamespace());
        nacosDiscoveryProperties.setGroup(dwDiscoveryProperties.getGroup());
    }

    public void registerEAI(Map<String, String> metadata, ObjectProvider<DWEAIPropertiesBean> eaiPropertiesProvider) {
        DWEAIPropertiesBean eaiProperties = (DWEAIPropertiesBean)eaiPropertiesProvider.getIfAvailable();
        if (null != eaiProperties) {
            if (StringUtils.isNumeric((CharSequence)eaiProperties.getHostRetryInterval())) {
                metadata.put("eai.hostRetryInterval", eaiProperties.getHostRetryInterval());
            }
            if (StringUtils.isNumeric((CharSequence)eaiProperties.getHostRetryTimes())) {
                metadata.put("eai.hostRetryTimes", eaiProperties.getHostRetryTimes());
            }
            if (StringUtils.isNotBlank((CharSequence)eaiProperties.getRestfulServicePath())) {
                metadata.put("eai.restfulPath", eaiProperties.getRestfulServicePath());
            }
            if (StringUtils.isNotBlank((CharSequence)eaiProperties.getRestfulServiceCallbackPath())) {
                metadata.put("eai.callbackPath", eaiProperties.getRestfulServiceCallbackPath());
            }
        }
    }

    @Bean
    RegestionApplicationListener regestionApplicationListener(DWDiscoveryProperties dwDiscoveryProperties, NamingClientProxy namingClientProxy) {
        return new RegestionApplicationListener(dwDiscoveryProperties, namingClientProxy);
    }

    @Bean
    NamingClientProxy namingClientProxy(NacosServiceManager nacosServiceManager, NacosDiscoveryProperties nacosDiscoveryProperties) throws NoSuchFieldException, IllegalAccessException {
        NamingService namingService = nacosServiceManager.getNamingService();
        Field clientProxy = namingService.getClass().getDeclaredField("clientProxy");
        clientProxy.setAccessible(true);
        NamingClientProxy namingClientProxy = (NamingClientProxy)clientProxy.get(namingService);
        return namingClientProxy;
    }

    @Bean
    ESPExecutorPoolProperties espExecutorPoolProperties() {
        return new ESPExecutorPoolProperties();
    }

    @Bean
    ServiceMetadataReactor serviceMetadataReactor(DWDiscoveryProperties dwDiscoveryProperties, NamingClientProxy namingClientProxy) {
        return new ServiceMetadataReactor(dwDiscoveryProperties, namingClientProxy);
    }

    @Bean
    public ESPLoadBalanceUtil init(DiscoveryClient discoveryClient, @Qualifier(value="dwDefaultHttpLoadbalanceRoute") DWDefaultHttpLoadbalanceRoute dwRoutePlanner, NacosServerListWatcher nacosServerListWatcher, Environment environment, NacosDiscoveryProperties nacosDiscoveryProperties, ESPExecutorPoolProperties espExecutorPoolProperties, ObjectProvider<DWEAIPropertiesBean> eaiPropertiesProvider, DWDiscoveryProperties dwDiscoveryProperties, ServiceMetadataReactor serviceMetadataReactor, TenantIdService tenantIdService, NamingClientProxy namingClientProxy) {
        ESPLoadBalanceUtil espLoadBalanceUtil = new ESPLoadBalanceUtil();
        String dwloadBalanceEnable = environment.getProperty("dwloadBalanceEnable");
        String esploadBalanceEnable = environment.getProperty("esp.loadbalance.enable");
        String cacheUnregisteredService = environment.getProperty("esp.cache.unregistered.service");
        if ("false".equalsIgnoreCase(cacheUnregisteredService)) {
            ESPLoadBalanceUtil.setCacheUnregisteredService(false);
        }
        if ("true".equalsIgnoreCase(dwloadBalanceEnable) && !"false".equalsIgnoreCase(esploadBalanceEnable)) {
            ESPLoadBalanceUtil.setLoadBalanceEnable(true);
        } else {
            ESPLoadBalanceUtil.setLoadBalanceEnable(false);
        }
        ESPLoadBalanceUtil.setDiscoveryClient(discoveryClient);
        ESPLoadBalanceUtil.setDwRoutePlanner(dwRoutePlanner);
        ESPLoadBalanceUtil.setNacosServerListWatcher(nacosServerListWatcher);
        ESPLoadBalanceUtil.setDiscoveryProperties(nacosDiscoveryProperties);
        ESPLoadBalanceUtil.setEspExecutorPoolProperties(espExecutorPoolProperties);
        ESPLoadBalanceUtil.setNamingHttpClientProxy(this.getNamingHttpClientProxy(namingClientProxy));
        ESPLoadBalanceUtil.setDwDiscoveryProperties(dwDiscoveryProperties);
        ESPLoadBalanceUtil.setServiceMetadataReactor(serviceMetadataReactor);
        ESPLoadBalanceUtil.setTenantIdService(tenantIdService);
        DWEAIPropertiesBean eaiProperties = (DWEAIPropertiesBean)eaiPropertiesProvider.getIfAvailable();
        if (null != eaiProperties) {
            if (StringUtils.isNumeric((CharSequence)eaiProperties.getHostRetryInterval())) {
                ESPLoadBalanceUtil.setEaiHostRetryInterval(Integer.valueOf(eaiProperties.getHostRetryInterval()));
            }
            if (StringUtils.isNumeric((CharSequence)eaiProperties.getHostRetryTimes())) {
                ESPLoadBalanceUtil.setEaiHostRetryTimes(Integer.valueOf(eaiProperties.getHostRetryTimes()));
            }
            ESPLoadBalanceUtil.setEaiRestfulPath(eaiProperties.getRestfulServicePath());
            ESPLoadBalanceUtil.setEaiCallbackPath(eaiProperties.getRestfulServiceCallbackPath());
        }
        return espLoadBalanceUtil;
    }

    private NamingHttpClientProxy getNamingHttpClientProxy(NamingClientProxy namingClientProxy) {
        if (namingClientProxy instanceof NamingClientProxyDelegate) {
            try {
                Field httpClientProxyField = namingClientProxy.getClass().getDeclaredField("httpClientProxy");
                httpClientProxyField.setAccessible(true);
                return (NamingHttpClientProxy)httpClientProxyField.get(namingClientProxy);
            }
            catch (Exception e) {
                throw new RuntimeException("can't get httpClientProxy");
            }
        }
        return null;
    }
}

