/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.autoconfigure.condition;

import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class DWLogOperationCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return DWLogOperationCondition.isLogOperationEnabled(context.getEnvironment());
    }

    public static boolean isLogOperationEnabled(Environment environment) {
        Objects.requireNonNull(environment);
        String operateLogEnabled = environment.getProperty("dap.dwlog.operation.enabled", "false");
        if (BooleanUtils.toBoolean((String)operateLogEnabled)) {
            return BooleanUtils.toBooleanObject((String)operateLogEnabled);
        }
        return false;
    }
}

