/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.concurrent;

import com.digiwin.app.log.operation.context.DWLogOperationContext;
import com.digiwin.app.log.operation.model.DWLogOperationBasicEntity;
import com.digiwin.app.log.operation.model.DWLogOperationErrorEntity;
import com.digiwin.app.log.operation.model.DWLogOperationSqlCommandEntity;
import com.digiwin.app.log.operation.vo.DWLogOperationBasicVo;
import com.digiwin.app.log.operation.vo.DWLogOperationCollection;
import com.digiwin.app.log.operation.vo.DWLogOperationErrorVo;
import com.digiwin.app.log.operation.vo.DWLogOperationSqlVo;
import com.digiwin.app.log.operation.vo.IDWLogOperationVo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;

public class DWLogOperationWorker
implements Runnable {
    private final Log LOGGER_ = LogFactory.getLog(this.getClass());
    boolean isDebug = this.LOGGER_.isDebugEnabled();
    boolean tenantEnable = BooleanUtils.toBoolean((String)System.getProperty("tenantEnabled", "true"));
    String tenantColumnName = System.getProperty("tenantColumnname", "tenantsid");
    private DWLogOperationContext logOperationContext;
    private DataSource dataSource;
    private String traceId;
    private final DWLogOperationCollection logOperationVoCollection;

    public DWLogOperationWorker(DWLogOperationCollection logOperationVoCollection, DWLogOperationContext logOperationContext) {
        this.logOperationVoCollection = logOperationVoCollection;
        this.logOperationContext = logOperationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StopWatch stopWatch = StopWatch.createStarted();
        this.traceId = this.logOperationContext.getServiceInfoData().getTraceId();
        ThreadContext.put((String)"traceId", (String)this.traceId);
        String currentThreadName = Thread.currentThread().getName();
        if (this.isDebug) {
            this.LOGGER_.debug((Object)String.format("[DWLogOperationWorker] thread:%s, starting...(traceId:%s))", currentThreadName, this.traceId));
        }
        try {
            this.process(this.logOperationVoCollection);
        }
        catch (Exception e) {
            try {
                this.LOGGER_.info((Object)String.format("[DWLogOperationWorker] thread:%s, exception:%s (traceId:%s)", currentThreadName, e.getCause(), this.traceId));
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                if (this.isDebug) {
                    this.LOGGER_.debug((Object)String.format("[DWLogOperationWorker] thread:%s, takes %d ms (traceId:%s))", currentThreadName, stopWatch.getTime(), this.traceId));
                }
                throw throwable;
            }
            stopWatch.stop();
            if (this.isDebug) {
                this.LOGGER_.debug((Object)String.format("[DWLogOperationWorker] thread:%s, takes %d ms (traceId:%s))", currentThreadName, stopWatch.getTime(), this.traceId));
            }
        }
        stopWatch.stop();
        if (this.isDebug) {
            this.LOGGER_.debug((Object)String.format("[DWLogOperationWorker] thread:%s, takes %d ms (traceId:%s))", currentThreadName, stopWatch.getTime(), this.traceId));
        }
    }

    private void process(Object data) {
        try {
            if (data instanceof DWLogOperationCollection) {
                for (IDWLogOperationVo voRow : ((DWLogOperationCollection)data).getVoList()) {
                    this.writeData(voRow);
                }
            } else if (data instanceof IDWLogOperationVo) {
                this.writeData((IDWLogOperationVo)data);
            }
        }
        catch (Exception exp) {
            this.LOGGER_.info((Object)("[DWLogOperationWorker] writeData process:" + exp.fillInStackTrace()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(IDWLogOperationVo opertVo) throws Exception {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.dataSource.getConnection();
            if (opertVo instanceof DWLogOperationSqlVo) {
                Object valueArry;
                DWLogOperationSqlVo sqlVo = (DWLogOperationSqlVo)opertVo;
                sqlVo.setLogOperationContext(this.logOperationContext);
                List sqlCommandModelList = (List)sqlVo.getData();
                String sqlCommand = "";
                int realColumnLength = 7;
                if (this.tenantEnable) {
                    valueArry = Collections.nCopies(++realColumnLength, "?").toArray(new String[realColumnLength]);
                    sqlCommand = String.format("insert into dw_log_operation_sql( log_id, operation_log_id, log_type, cmd_table, cmd_statement , cmd_parameters, cmd_seq  %s )  values ( %s)", " , " + this.tenantColumnName, StringUtils.join((Object[])valueArry, (String)", "));
                } else {
                    valueArry = Collections.nCopies(realColumnLength, "?").toArray(new String[realColumnLength]);
                    sqlCommand = String.format("insert into dw_log_operation_sql( log_id, operation_log_id, log_type, cmd_table, cmd_statement , cmd_parameters, cmd_seq  %s )  values ( %s)", "", StringUtils.join((Object[])valueArry, (String)", "));
                }
                pstmt = con.prepareStatement(sqlCommand);
                con.setAutoCommit(false);
                for (DWLogOperationSqlCommandEntity dataVo : sqlCommandModelList) {
                    pstmt.setString(1, dataVo.getLogId());
                    pstmt.setString(2, dataVo.getServiceLogId());
                    pstmt.setInt(3, dataVo.getLogType());
                    pstmt.setString(4, dataVo.getExecuteTableName());
                    pstmt.setString(5, dataVo.getExecuteCommand());
                    pstmt.setString(6, dataVo.getExecuteParameter());
                    pstmt.setInt(7, dataVo.getExecuteSeq());
                    if (this.tenantEnable) {
                        pstmt.setLong(realColumnLength, dataVo.getTenantSid());
                    }
                    pstmt.addBatch();
                }
                int[] count = pstmt.executeBatch();
                con.commit();
                pstmt.close();
            } else if (opertVo instanceof DWLogOperationBasicVo) {
                DWLogOperationBasicVo basicVo = (DWLogOperationBasicVo)opertVo;
                basicVo.setLogOperationContext(this.logOperationContext);
                DWLogOperationBasicEntity basicModel = (DWLogOperationBasicEntity)basicVo.getData();
                if (basicModel != null) {
                    String sqlCommand = "";
                    int realColumnLength = 13;
                    if (this.tenantEnable) {
                        Object[] valueArry = Collections.nCopies(++realColumnLength, "?").toArray(new String[realColumnLength]);
                        sqlCommand = String.format("insert into dw_log_operation( log_id, operate_desc, menu, module, url, input_value, time_consume , client_ip, traceid, create_name, return_value, status , remark %s )  values ( %s)", " , " + this.tenantColumnName, StringUtils.join((Object[])valueArry, (String)", "));
                    } else {
                        Object[] valueArry = Collections.nCopies(realColumnLength, "?").toArray(new String[realColumnLength]);
                        sqlCommand = String.format("insert into dw_log_operation( log_id, operate_desc, menu, module, url, input_value, time_consume , client_ip, traceid, create_name, return_value, status , remark %s )  values ( %s)", "", StringUtils.join((Object[])valueArry, (String)", "));
                    }
                    pstmt = con.prepareStatement(sqlCommand);
                    pstmt.setObject(1, opertVo.getOpMainLogId());
                    pstmt.setObject(2, basicModel.getOperateDesc());
                    pstmt.setObject(3, basicModel.getMenu());
                    pstmt.setObject(4, basicModel.getModule());
                    pstmt.setObject(5, basicModel.getUrl());
                    pstmt.setObject(6, basicModel.getInputValue());
                    pstmt.setObject(7, basicModel.getTimeConsume());
                    pstmt.setObject(8, basicModel.getClientIp());
                    pstmt.setObject(9, basicModel.getTraceId());
                    pstmt.setObject(10, basicModel.getCreateName());
                    pstmt.setObject(11, basicModel.getReturnValue());
                    pstmt.setInt(12, basicModel.getStatus());
                    pstmt.setObject(13, basicModel.getRemark());
                    if (this.tenantEnable) {
                        pstmt.setLong(realColumnLength, basicModel.getTenantSid());
                    }
                    if (pstmt != null) {
                        pstmt.executeUpdate();
                        pstmt.close();
                    }
                }
            } else if (opertVo instanceof DWLogOperationErrorVo) {
                DWLogOperationErrorVo errorVo = (DWLogOperationErrorVo)opertVo;
                errorVo.setLogOperationContext(this.logOperationContext);
                DWLogOperationErrorEntity errorModel = (DWLogOperationErrorEntity)errorVo.getData();
                if (errorModel != null) {
                    String sqlCommand = "";
                    int realColumnLength = 13;
                    if (this.tenantEnable) {
                        Object[] valueArry = Collections.nCopies(++realColumnLength, "?").toArray(new String[realColumnLength]);
                        sqlCommand = String.format("insert into dw_log_operation_error( log_id, operate_desc, menu, module, url, input_value, time_consume , client_ip, traceid, create_name, error_type, error_message , prog_impl %s )  values ( %s)", " , " + this.tenantColumnName, StringUtils.join((Object[])valueArry, (String)", "));
                    } else {
                        Object[] valueArry = Collections.nCopies(realColumnLength, "?").toArray(new String[realColumnLength]);
                        sqlCommand = String.format("insert into dw_log_operation( log_id, operate_desc, menu, module, url, input_value, time_consume , client_ip, traceid, create_name, return_value, status , remark %s )  values ( %s)", "", StringUtils.join((Object[])valueArry, (String)", "));
                    }
                    pstmt = con.prepareStatement(sqlCommand);
                    pstmt.setObject(1, opertVo.getOpMainLogId());
                    pstmt.setObject(2, errorModel.getOperateDesc());
                    pstmt.setObject(3, errorModel.getMenu());
                    pstmt.setObject(4, errorModel.getModule());
                    pstmt.setObject(5, errorModel.getUrl());
                    pstmt.setObject(6, errorModel.getInputValue());
                    pstmt.setObject(7, errorModel.getTimeConsume());
                    pstmt.setObject(8, errorModel.getClientIp());
                    pstmt.setObject(9, errorModel.getTraceId());
                    pstmt.setObject(10, errorModel.getCreateName());
                    pstmt.setObject(11, errorModel.getErrorType());
                    pstmt.setObject(12, errorModel.getErrorMessage());
                    pstmt.setObject(13, errorModel.getProgImpl());
                    if (this.tenantEnable) {
                        pstmt.setLong(realColumnLength, errorModel.getTenantSid());
                    }
                    if (pstmt != null) {
                        pstmt.executeUpdate();
                        pstmt.close();
                    }
                }
            }
        }
        catch (Exception exp) {
            this.LOGGER_.info((Object)("[DWLogOperationWorker] writeData exception:" + exp.fillInStackTrace()));
        }
        finally {
            if (!con.getAutoCommit()) {
                con.setAutoCommit(true);
            }
            if (con != null) {
                con.close();
            }
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

