/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.vo;

import com.digiwin.app.log.operation.context.DWLogOperationContext;
import com.digiwin.app.log.operation.model.DWLogOperationAnnotationField;
import com.digiwin.app.log.operation.model.DWLogOperationBasicEntity;
import com.digiwin.app.log.operation.model.DWLogOperationServiceInfoData;
import com.digiwin.app.log.operation.utils.DWLogOperationDataHelper;
import com.digiwin.app.log.operation.vo.DWLogAbstractOperationVo;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public class DWLogOperationBasicVo
extends DWLogAbstractOperationVo {
    private MethodInvocation invocation;
    private long timeConsume;
    private Object invocationReturnValue;

    public DWLogOperationBasicVo(MethodInvocation invocation, long timeConsume, Object invocationReturnValue) {
        this.invocation = invocation;
        this.timeConsume = timeConsume;
        this.invocationReturnValue = invocationReturnValue;
        this.setOpMainLogId(DWLogOperationDataHelper.generateLogId());
        this.setTargetTableName("dw_log_operation");
    }

    @Override
    public Object getData() {
        return this.filterData(this.invocation, this.invocationReturnValue);
    }

    public Object filterData(MethodInvocation invocation, Object result) {
        DWLogOperationBasicEntity basicModel = new DWLogOperationBasicEntity();
        try {
            Method method = invocation.getMethod();
            DWLogOperationContext logOperationContext = this.getLogOperationContext();
            basicModel.setLogId(this.getOpMainLogId());
            basicModel.setClientIp(logOperationContext.getClientIp());
            basicModel.setUrl(logOperationContext.getServiceUrl());
            basicModel.setInputValue(logOperationContext.getInputValue());
            basicModel.setReturnValue(DWLogOperationDataHelper.getReturnValueReadableData(result));
            basicModel.setMethod(method.getName());
            basicModel.setTimeConsume(logOperationContext.getTimeConsume());
            DWLogOperationServiceInfoData serviceInfoData = logOperationContext.getServiceInfoData();
            basicModel.setTraceId(serviceInfoData.getTraceId());
            basicModel.setModule(serviceInfoData.getModuleName());
            basicModel.setCreateName(serviceInfoData.getCreateUserName());
            basicModel.setTenantSid(serviceInfoData.getTenantSid());
            basicModel.setRemark(serviceInfoData.getRemark());
            DWLogOperationAnnotationField annoField = logOperationContext.getOperateLog();
            if (annoField != null) {
                basicModel.setOperateDesc(annoField.getOperateDesc());
                basicModel.setOperateType(annoField.getOperateType());
                basicModel.setMenu(annoField.getOperateMenu());
                basicModel.setStatus(annoField.getOperateStatus());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return basicModel;
    }
}

