/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.aop;

import com.digiwin.app.log.operation.annotation.DWLogOperation;
import com.digiwin.app.log.operation.config.DWLogOperationProperties;
import com.digiwin.app.log.operation.context.DWLogOperationContext;
import com.digiwin.app.log.operation.dao.ILogOperationDao;
import com.digiwin.app.log.operation.model.DWLogOperationAnnotationField;
import com.digiwin.app.log.operation.utils.DWLogOperationDataHelper;
import com.digiwin.app.log.operation.utils.DWLogOperationPropertyUtil;
import com.digiwin.app.log.operation.utils.IpUtils;
import com.digiwin.app.log.operation.vo.DWLogOperationBasicVo;
import com.digiwin.app.log.operation.vo.DWLogOperationCollection;
import com.digiwin.app.log.operation.vo.DWLogOperationErrorVo;
import com.digiwin.app.log.operation.vo.DWLogOperationSqlVo;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DWLogOperationInterceptor
implements MethodInterceptor {
    @Autowired
    @Qualifier(value="dw-log-operation-configuration-properties")
    private DWLogOperationProperties operateLogProperties;
    @Autowired
    @Qualifier(value="dw-log-operation-dao")
    private ILogOperationDao dwLogRecordDao;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result = null;
        Method method = invocation.getMethod();
        boolean isLogOperationEnabled = this.getLogOperationEnabledAndBeforeMethodInvoke(method);
        StopWatch stopWatch = StopWatch.createStarted();
        try {
            result = invocation.proceed();
        }
        catch (Throwable e) {
            if (!stopWatch.isStopped()) {
                stopWatch.stop();
            }
            if (isLogOperationEnabled) {
                this.writeOperateLogError(invocation, stopWatch.getTime(), e);
            }
            throw e;
        }
        finally {
            if (!stopWatch.isStopped()) {
                stopWatch.stop();
            }
        }
        long timeConsume = stopWatch.getTime();
        if (isLogOperationEnabled) {
            this.writeOperateLog(invocation, timeConsume, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOperateLog(MethodInvocation invocation, long timeConsume, Object result) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (this.operateLogProperties == null || !this.operateLogProperties.isEnabled()) {
            return;
        }
        this.addDataToLogOperationContext(invocation, timeConsume);
        try {
            DWLogOperationBasicVo dwLogOperationVo = new DWLogOperationBasicVo(invocation, timeConsume, result);
            dwLogOperationVo.setOperateLogProperties(this.operateLogProperties);
            DWLogOperationCollection logVoCollection = new DWLogOperationCollection();
            logVoCollection.addVo(dwLogOperationVo);
            String serviceOpLogId = dwLogOperationVo.getOpMainLogId();
            DWLogOperationAnnotationField annotationField = DWLogOperationContext.getContext().getOperateLog();
            if (annotationField != null) {
                if (annotationField.isMergedLogBasicEnable() && annotationField.isMergedLogSqlEnabled() && StringUtils.isNotEmpty((CharSequence)serviceOpLogId)) {
                    DWLogOperationSqlVo dwLogOperationSqlVo = new DWLogOperationSqlVo(serviceOpLogId);
                    logVoCollection.addVo(dwLogOperationSqlVo);
                }
            } else {
                DWLogOperationSqlVo dwLogOperationSqlVo = new DWLogOperationSqlVo(serviceOpLogId);
                logVoCollection.addVo(dwLogOperationSqlVo);
            }
            this.dwLogRecordDao.writeLogOperation(logVoCollection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DWLogOperationContext.getCurrentLogContextOfThread().remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOperateLogError(MethodInvocation invocation, long timeConsume, Throwable result) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (this.operateLogProperties == null || !this.operateLogProperties.isEnabled() || !this.operateLogProperties.isLogErrorEnabled()) {
            return;
        }
        try {
            DWLogOperationErrorVo dwLogOperationVo = new DWLogOperationErrorVo(invocation, timeConsume, result);
            dwLogOperationVo.setOperateLogProperties(this.operateLogProperties);
            DWLogOperationCollection logVoCollection = new DWLogOperationCollection();
            logVoCollection.addVo(dwLogOperationVo);
            this.addDataToLogOperationContext(invocation, timeConsume);
            this.dwLogRecordDao.writeLogOperation(logVoCollection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DWLogOperationContext.getCurrentLogContextOfThread().remove();
        }
    }

    private boolean getLogOperationEnabledAndBeforeMethodInvoke(Method method) {
        boolean isLogOperationEnabled = true;
        DWLogOperation dwLogOperationAnnotation = method.getAnnotation(DWLogOperation.class);
        if (this.operateLogProperties != null) {
            DWLogOperationPropertyUtil.updateOperatLogEnabledInfo(this.operateLogProperties, dwLogOperationAnnotation);
        }
        return isLogOperationEnabled;
    }

    private void addDataToLogOperationContext(MethodInvocation invocation, long timeConsume) {
        DWLogOperationContext logOperationContext = DWLogOperationContext.getContext();
        logOperationContext.setClientIp(IpUtils.getRequestIpAddr());
        logOperationContext.setServiceUrl(DWLogOperationDataHelper.getRequestPath());
        logOperationContext.setInputValue(DWLogOperationDataHelper.getInputValueReadableData(invocation));
        logOperationContext.setTimeConsume(BigInteger.valueOf(timeConsume));
    }
}

