/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.utils;

import com.digiwin.app.log.operation.annotation.DWLogOperation;
import com.digiwin.app.log.operation.config.DWLogOperationProperties;
import com.digiwin.app.log.operation.context.DWLogOperationContext;
import com.digiwin.app.log.operation.model.DWLogOperationAnnotationField;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWLogOperationPropertyUtil {
    private static Log LOGGER_ = LogFactory.getLog(DWLogOperationPropertyUtil.class);

    public static boolean getEnabled(Map<String, Object> sqlLogOptions) {
        String operateLogEnabled = (String)sqlLogOptions.getOrDefault("logOperationEnabled", "false");
        if (BooleanUtils.toBoolean((String)operateLogEnabled)) {
            return BooleanUtils.toBooleanObject((String)operateLogEnabled);
        }
        return false;
    }

    public static DWLogOperationAnnotationField updateOperatLogEnabledInfo(DWLogOperationProperties operateLogProperties, DWLogOperation annotationData) {
        Objects.requireNonNull(operateLogProperties, "operateLogProperties is required");
        DWLogOperationAnnotationField targetlogOperationField = DWLogOperationContext.getContext().getOperateLog();
        targetlogOperationField.setMergedLogBasicEnable(operateLogProperties.isEnabled());
        if (operateLogProperties.isEnabled() && annotationData != null) {
            if (targetlogOperationField == null) {
                targetlogOperationField = new DWLogOperationAnnotationField();
                targetlogOperationField.setOperateDesc(annotationData.desc());
                targetlogOperationField.setOperateType(annotationData.type());
                targetlogOperationField.setOperateMenu(annotationData.menu());
                targetlogOperationField.setOperateStatus(annotationData.status());
            } else {
                if (StringUtils.isBlank((CharSequence)targetlogOperationField.getOperateDesc())) {
                    targetlogOperationField.setOperateDesc(annotationData.desc());
                }
                if (StringUtils.isBlank((CharSequence)targetlogOperationField.getOperateType())) {
                    targetlogOperationField.setOperateType(annotationData.type());
                }
                if (StringUtils.isBlank((CharSequence)targetlogOperationField.getOperateMenu())) {
                    targetlogOperationField.setOperateMenu(annotationData.menu());
                }
                if (targetlogOperationField.getOperateStatus() != 1) {
                    targetlogOperationField.setOperateStatus(annotationData.status());
                }
            }
            targetlogOperationField.setMergedLogSqlEnabled(DWLogOperationPropertyUtil.getCombinedBoolean("isLogSqlRecord", operateLogProperties.isLogSqlEnabled(), annotationData.logSql()));
            targetlogOperationField.setMergedLogErrorEnabled(DWLogOperationPropertyUtil.getCombinedBoolean("isLogErrorRecord", operateLogProperties.isLogErrorEnabled(), annotationData.logError()));
        } else {
            targetlogOperationField.setMergedLogSqlEnabled(operateLogProperties.isLogSqlEnabled());
            targetlogOperationField.setMergedLogErrorEnabled(operateLogProperties.isLogErrorEnabled());
        }
        return targetlogOperationField;
    }

    private static boolean getCombinedBoolean(String property, boolean topLevel, boolean secondLevel) {
        boolean returnValue = false;
        returnValue = topLevel ? secondLevel : topLevel;
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug((Object)String.format("[%s] vaule=%b (properties:%b, annotation:%b)", property, returnValue, topLevel, secondLevel));
        }
        return returnValue;
    }

    public void setValue() {
    }
}

