/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.vo;

import com.digiwin.app.log.operation.context.DWLogOperationContext;
import com.digiwin.app.log.operation.model.DWLogOperationAnnotationField;
import com.digiwin.app.log.operation.model.DWLogOperationErrorEntity;
import com.digiwin.app.log.operation.model.DWLogOperationServiceInfoData;
import com.digiwin.app.log.operation.utils.DWLogOperationDataHelper;
import com.digiwin.app.log.operation.vo.DWLogAbstractOperationVo;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DWLogOperationErrorVo
extends DWLogAbstractOperationVo {
    private MethodInvocation invocation;
    private long timeConsume;
    private Throwable throwable;
    private static int stringMaxLength = 1000;

    public DWLogOperationErrorVo(MethodInvocation invocation, long timeConsume, Throwable throwable) {
        this.invocation = invocation;
        this.timeConsume = timeConsume;
        this.throwable = throwable;
        this.setOpMainLogId(DWLogOperationDataHelper.generateLogId());
        this.setTargetTableName("dw_log_operation_error");
    }

    @Override
    public Object getData() {
        return this.filterData(this.invocation, this.throwable);
    }

    public Object filterData(MethodInvocation invocation, Object throwable) {
        DWLogOperationErrorEntity rowErrorModel = new DWLogOperationErrorEntity();
        try {
            Method method = invocation.getMethod();
            DWLogOperationContext logOperationContext = this.getLogOperationContext();
            String log_id = this.getOpMainLogId();
            rowErrorModel.setLogId(log_id);
            rowErrorModel.setClientIp(logOperationContext.getClientIp());
            rowErrorModel.setUrl(logOperationContext.getServiceUrl());
            rowErrorModel.setInputValue(logOperationContext.getInputValue());
            rowErrorModel.setTimeConsume(logOperationContext.getTimeConsume());
            rowErrorModel.setErrorMessage(DWLogOperationErrorVo.getErrorValueReadableData((Throwable)throwable));
            rowErrorModel.setProgImpl(method.getDeclaringClass().getName() + "." + method.getName());
            DWLogOperationServiceInfoData serviceInfoData = logOperationContext.getServiceInfoData();
            rowErrorModel.setTraceId(serviceInfoData.getTraceId());
            rowErrorModel.setModule(serviceInfoData.getModuleName());
            rowErrorModel.setCreateName(serviceInfoData.getCreateUserName());
            rowErrorModel.setTenantSid(serviceInfoData.getTenantSid());
            rowErrorModel.setAppId((String)serviceInfoData.getServiceProfile().get("appId"));
            rowErrorModel.setTenantId((String)serviceInfoData.getServiceProfile().get("tenantId"));
            rowErrorModel.setUserId((String)serviceInfoData.getServiceProfile().get("userId"));
            rowErrorModel.setHeader((String)serviceInfoData.getServiceProfile().get("header"));
            DWLogOperationAnnotationField annoField = logOperationContext.getOperateLog();
            if (annoField != null) {
                rowErrorModel.setOperateDesc(annoField.getOperateDesc());
                rowErrorModel.setOperateType(annoField.getOperateType());
                rowErrorModel.setMenu(annoField.getOperateMenu());
            }
            if (throwable != null && throwable instanceof RuntimeException) {
                rowErrorModel.setErrorType("2");
            } else {
                rowErrorModel.setErrorType("1");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowErrorModel;
    }

    public static String getErrorValueReadableData(Throwable result) {
        if (result == null) {
            return "";
        }
        String returnValue = StringUtils.abbreviate((String)ExceptionUtils.getStackTrace((Throwable)result), (int)stringMaxLength);
        return returnValue;
    }
}

