/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.log.DWExtendedLogger;
import com.digiwin.app.log.Log4j2XmlHolder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.message.MessageFactory;

public class DWLoggerContext
extends LoggerContext
implements org.apache.logging.log4j.spi.LoggerContext {
    private static Map<String, DWExtendedLogger> repository = new ConcurrentHashMap<String, DWExtendedLogger>();
    private static LoggerContext innerContext = new LoggerContext("");

    public DWLoggerContext(String name) {
        super(name);
    }

    public static String initLog4j2Xml(String xml) {
        String logFileIdentifierValue = DWApplicationConfigUtils.getProperty((String)"logFileIdentifier", (String)"");
        if ("@logFileIdentifier@".equalsIgnoreCase(logFileIdentifierValue)) {
            logFileIdentifierValue = "";
        }
        Interpolator lookup = new Interpolator();
        StrSubstitutor replacer = new StrSubstitutor((StrLookup)lookup);
        String identifier = replacer.replace(logFileIdentifierValue);
        System.setProperty("logFileIdentifier", identifier);
        Log4j2XmlHolder.setXml(xml);
        return identifier;
    }

    public Logger getLogger(String name) {
        return this.getLogger(name, null);
    }

    public Logger getLogger(String name, MessageFactory messageFactory) {
        if (repository.containsKey(name)) {
            DWExtendedLogger logger = repository.get(name);
            return logger;
        }
        DWExtendedLogger logger = new DWExtendedLogger(name);
        repository.put(name, logger);
        return logger;
    }

    public static LoggerContext getContext() {
        return innerContext;
    }

    public static void setContext(LoggerContext context) {
        innerContext = context;
    }
}

