/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.concurrent;

import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWSQLOptionsBuilder;
import com.digiwin.app.log.operation.context.DWLogOperationContext;
import com.digiwin.app.log.operation.vo.DWLogOperationCollection;
import com.digiwin.app.log.operation.vo.DWLogOperationSqlVo;
import com.digiwin.app.log.operation.vo.IDWLogOperationVo;
import com.digiwin.app.service.DWServiceContext;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWLogOperationRunnable
implements Runnable {
    private final Log log = LogFactory.getLog(this.getClass());
    boolean isDebug = this.log.isDebugEnabled();
    private DWLogOperationContext logOperationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StopWatch stopWatch = StopWatch.createStarted();
        String currentThreadName = Thread.currentThread().getName();
        DWServiceContext.setContext((DWServiceContext)this.logOperationContext.getServiceContext());
        String traceId = this.logOperationContext.getTraceId();
        if (this.isDebug) {
            this.log.debug((Object)String.format("[DWLogOperationRunnable] thread:%s, starting...(traceId:%s))", currentThreadName, traceId));
        }
        try {
            DWDataSetOperationOption daoOptions = new DWDataSetOperationOption();
            daoOptions.set(DWSQLOptionsBuilder.OPTION_LOG_OPERATION_ENABLED, (Object)false);
            daoOptions.setManagementFieldEnabled(false);
            DWDataSet dataSet = this.generateDataSet(this.logOperationContext.getData());
            this.logOperationContext.getDao().execute(dataSet, daoOptions);
        }
        catch (Exception e) {
            try {
                this.log.info((Object)String.format("[DWLogOperationRunnable] thread:%s, exception:%s (traceId:%s)", currentThreadName, e.getCause(), traceId));
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                if (this.isDebug) {
                    this.log.debug((Object)String.format("[DWLogOperationRunnable] thread:%s, takes %d (traceId:%s))", currentThreadName, stopWatch.getTime(), traceId));
                }
                throw throwable;
            }
            stopWatch.stop();
            if (this.isDebug) {
                this.log.debug((Object)String.format("[DWLogOperationRunnable] thread:%s, takes %d (traceId:%s))", currentThreadName, stopWatch.getTime(), traceId));
            }
        }
        stopWatch.stop();
        if (this.isDebug) {
            this.log.debug((Object)String.format("[DWLogOperationRunnable] thread:%s, takes %d (traceId:%s))", currentThreadName, stopWatch.getTime(), traceId));
        }
    }

    public DWLogOperationContext getLogOperationContext() {
        return this.logOperationContext;
    }

    public DWLogOperationRunnable setLogOperationContext(DWLogOperationContext logOperationContext) {
        this.logOperationContext = logOperationContext;
        return this;
    }

    private DWDataSet generateDataSet(Object data) {
        DWDataSet dataSet = new DWDataSet();
        if (data instanceof DWLogOperationCollection) {
            for (IDWLogOperationVo voRow : ((DWLogOperationCollection)data).getVoList()) {
                this.process(dataSet, voRow);
            }
        } else if (data instanceof IDWLogOperationVo) {
            this.process(dataSet, (IDWLogOperationVo)data);
        }
        return dataSet;
    }

    private void process(DWDataSet dataSet, IDWLogOperationVo opertVo) {
        if (opertVo instanceof DWLogOperationSqlVo) {
            DWLogOperationSqlVo sqlVo = (DWLogOperationSqlVo)opertVo;
            List dataList = (List)sqlVo.getData();
            dataSet.newTable(sqlVo.getTargetTableName()).newRows(dataList);
        } else {
            dataSet.newTable(opertVo.getTargetTableName()).newRow((Map)opertVo.getData());
        }
    }
}

