/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.utils;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.log.operation.context.DWLogOperationContext;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.UUID;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWLogOperationDataHelper {
    private static final Log log = LogFactory.getLog(DWLogOperationDataHelper.class);
    private static boolean isDebugEnabled = log.isDebugEnabled();
    private static Gson _gson = DWGsonProvider.getGson();
    private static int stringMaxLength = 1000;

    public static boolean getCombine(String property, boolean topLevel, boolean secondLevel) {
        boolean returnValue = false;
        returnValue = topLevel ? secondLevel : topLevel;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("[%s] vaule=%b (properties:%b, annotation:%b)", property, returnValue, topLevel, secondLevel));
        }
        return returnValue;
    }

    @Deprecated
    public static String getTraceId() {
        String traceId = DWLogOperationContext.getContext().getTraceId();
        if (isDebugEnabled) {
            log.debug((Object)String.format("[DWLogOperationDataHelper] getTraceId()=%s", traceId));
        }
        return traceId;
    }

    public static String generateLogId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String getParameterData(Object[] parametersObj) {
        ArrayList<String> parametersData = new ArrayList<String>();
        for (Object p : parametersObj) {
            StringBuilder rowTemp = new StringBuilder();
            rowTemp.append(p.toString());
            if (p == null) {
                rowTemp.append("(Unknown)");
            } else {
                rowTemp.append("(").append(p.getClass().getSimpleName()).append(")");
            }
            parametersData.add(rowTemp.toString());
        }
        String result = StringUtils.join((Object[])parametersData.toArray(), (String)";;");
        return result;
    }

    public static Object getReturnValueReadableData(Object result) throws Exception {
        if (result == null) {
            return result;
        }
        result = StringUtils.abbreviate((String)_gson.toJson(result, result.getClass()), (int)stringMaxLength);
        return result;
    }

    public static String getInputValueReadableData(MethodInvocation invocation) {
        StringBuilder message = new StringBuilder();
        Object[] arguments = invocation.getArguments();
        if (arguments == null) {
            message.append(arguments);
        } else {
            for (int i = 0; i < arguments.length; ++i) {
                if (i != 0) {
                    message.append(", ");
                }
                if (arguments[i] == null) {
                    message.append("null");
                    continue;
                }
                String a = _gson.toJson(arguments[i]);
                message.append((Object)a);
            }
        }
        message.append(")");
        return StringUtils.abbreviate((String)message.toString(), (int)stringMaxLength);
    }
}

