/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.utils;

import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.digiwin.app.log.operation.context.DWLogOperationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletRequestAttributes;

public class IpUtils {
    private static final Log log = LogFactory.getLog(IpUtils.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private static final List<String> headersPattern = Arrays.asList("x-forwarded-for", "proxy-client-ip", "wl-proxy-client-ip", "http_x_forwarded_for", "http_x_forwarded", "http_x_cluster_client_ip", "http_client_ip", "http_forwarded_for", "http_forwarded", "http_via", "remote_addr");

    public static String getRequestIpAddr() {
        RequestAttributes requestAttributes = DWLogOperationContext.getContext().getRequestAttributes();
        if (requestAttributes == null) {
            return "0.0.0.0";
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        return IpUtils.getRequestIpAddr(request);
    }

    public static String getRequestIpAddr(HttpServletRequest request) {
        if (request == null) {
            if (isDebugEnabled) {
                log.debug((Object)"[IpUtils.getRequestIpAddr] request=null");
            }
            return "unknown";
        }
        String ip = "";
        ArrayList httpHeaderNames = Collections.list(request.getHeaderNames());
        if (!Collections.disjoint(headersPattern, httpHeaderNames)) {
            String headerIp = "";
            for (String header : headersPattern) {
                headerIp = request.getHeader(header);
                if (headerIp == null || headerIp.length() == 0 || "unknown".equalsIgnoreCase(headerIp)) continue;
                if (isDebugEnabled) {
                    log.debug((Object)String.format("[IpUtils] clientIp:headerIp=%s", headerIp));
                }
                return headerIp;
            }
        } else if (isDebugEnabled) {
            log.debug((Object)"[IpUtils] clientIp: did not matched any header-list, trying request.getRemoteAddr()");
        }
        if (StringUtils.isEmpty((String)ip)) {
            ip = request.getRemoteAddr();
            if (isDebugEnabled) {
                log.debug((Object)String.format("[IpUtils] clientIp:request.getRemoteAddr=%s", ip));
            }
            ip = "0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : ip;
        }
        return ip;
    }
}

