/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.vo;

import com.digiwin.app.log.operation.context.DWLogOperationContext;
import com.digiwin.app.log.operation.utils.DWLogOperationDataHelper;
import com.digiwin.app.log.operation.vo.DWLogAbstractOperationVo;
import com.digiwin.app.service.DWServiceContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DWLogOperationSqlVo
extends DWLogAbstractOperationVo {
    private Object paramsObj;

    public DWLogOperationSqlVo(String serviceOpLogId) {
        this.setOpMainLogId(serviceOpLogId);
        this.setTargetTableName("dw_log_operation_sql");
    }

    @Override
    public Object getData() {
        return this.filterData();
    }

    public List<Map<String, Object>> filterData() {
        ArrayList<Map<String, Object>> listData = new ArrayList<Map<String, Object>>();
        try {
            HashMap<String, Object> dwLogEventBasicMap = new HashMap<String, Object>();
            dwLogEventBasicMap.put("operation_log_id", this.getOpMainLogId());
            dwLogEventBasicMap.put("$state", "C");
            dwLogEventBasicMap.put("log_type", 1);
            DWLogOperationContext.getContext().getServiceContext();
            Map sqlMap = (Map)DWServiceContext.getContext().getOperateLog().get("sqlMap");
            if (sqlMap != null && sqlMap.size() > 0) {
                for (Integer key : sqlMap.keySet()) {
                    String sqlLogId = DWLogOperationDataHelper.generateLogId();
                    HashMap<String, Object> dwLogEventMap = new HashMap<String, Object>();
                    Map rowSqlMap = (Map)sqlMap.get(key);
                    dwLogEventMap.putAll(dwLogEventBasicMap);
                    dwLogEventMap.put("log_id", sqlLogId);
                    dwLogEventMap.put("cmd_statement", rowSqlMap.get("statement"));
                    dwLogEventMap.put("cmd_parameters", this.getSqlParamters(rowSqlMap.get("parameters")));
                    dwLogEventMap.put("cmd_seq", key);
                    listData.add(dwLogEventMap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listData;
    }

    private String getSqlParamters(Object paramsObj) {
        ArrayList<String> parametersData = new ArrayList<String>();
        for (Object p : (List)paramsObj) {
            StringBuilder rowTemp = new StringBuilder();
            rowTemp.append(p.toString());
            parametersData.add(rowTemp.toString());
        }
        return StringUtils.join((Object[])parametersData.toArray(), (String)";;");
    }

    private String getRunnableSqlStatement(Map<String, Object> rowSqlMap) {
        String sqlStatement = (String)rowSqlMap.get("statement");
        Object paramsObj = rowSqlMap.get("parameters");
        if (StringUtils.isNotEmpty((CharSequence)sqlStatement) && paramsObj != null) {
            List params = (List)paramsObj;
            for (Object value : params) {
                if (value instanceof String) {
                    sqlStatement = sqlStatement.replaceFirst("\\?", "'" + value.toString() + "'");
                    continue;
                }
                sqlStatement = sqlStatement.replaceFirst("\\?", value.toString());
            }
        } else {
            return sqlStatement;
        }
        return sqlStatement;
    }
}

