/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.vo;

import com.digiwin.app.log.operation.annotation.DWLogOperation;
import com.digiwin.app.log.operation.concurrent.DWLogOperationWorker;
import com.digiwin.app.log.operation.context.DWLogOperationContext;
import com.digiwin.app.log.operation.utils.DWLogOperationDataHelper;
import com.digiwin.app.log.operation.vo.DWLogAbstractOperationVo;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;

public class DWLogOperationServiceVo
extends DWLogAbstractOperationVo {
    private MethodInvocation invocation;
    private long timeConsume;
    private Object invocationReturnValue;

    public DWLogOperationServiceVo(MethodInvocation invocation, long timeConsume, Object invocationReturnValue) {
        this.invocation = invocation;
        this.timeConsume = timeConsume;
        this.invocationReturnValue = invocationReturnValue;
        this.setOpMainLogId(DWLogOperationDataHelper.generateLogId());
        this.setTargetTableName("dw_log_operation");
    }

    @Override
    public Object getData() {
        return this.filterData(this.invocation, this.timeConsume, this.invocationReturnValue);
    }

    public Object filterData(MethodInvocation invocation, long timeConsume, Object result) {
        HashMap<String, Object> rowDataMap = new HashMap<String, Object>();
        try {
            Method method = invocation.getMethod();
            DWLogOperation dwLogOperationAnnotation = method.getAnnotation(DWLogOperation.class);
            DWLogOperationContext operationContext = DWLogOperationWorker.getContext();
            rowDataMap.put("log_id", this.getOpMainLogId());
            rowDataMap.put("traceid", operationContext.getTraceId());
            rowDataMap.put("operate_desc", dwLogOperationAnnotation.desc());
            rowDataMap.put("module", operationContext.getModuleName());
            rowDataMap.put("client_ip", operationContext.getClientIp());
            rowDataMap.put("url", operationContext.getServiceUrl());
            rowDataMap.put("input_value", DWLogOperationDataHelper.getParameterData(invocation.getArguments()));
            rowDataMap.put("return_value", DWLogOperationDataHelper.getReturnValueReadableData(result));
            rowDataMap.put("time_consume", String.valueOf(timeConsume));
            rowDataMap.put("method", method.getName());
            rowDataMap.put("$state", "C");
            rowDataMap.put("create_name", operationContext.getCreateUserName());
            Map<String, Object> operateLogMap = operationContext.getOperateLog();
            if (operateLogMap != null) {
                if (operateLogMap.containsKey("operateType")) {
                    rowDataMap.put("operate_type", operateLogMap.get("operateType"));
                }
                if (operateLogMap.containsKey("operateMenu")) {
                    rowDataMap.put("menu", operateLogMap.get("operateMenu"));
                }
                if (operateLogMap.containsKey("operateStatus")) {
                    rowDataMap.put("status", operateLogMap.get("operateStatus"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowDataMap;
    }
}

