/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log;

import com.digiwin.app.log.DWExtendedLogger;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;

public class DWExtendedLogEvent
extends Log4jLogEvent {
    private StackTraceElement source;
    private static String slf4jJclLoggerFQCN = "org.slf4j.impl.JCLLoggerAdapter";
    private static String dwExtendedLoggerFQCN = DWExtendedLogger.class.getName();

    public DWExtendedLogEvent(String loggerName, Marker marker, String loggerFQCN, Level level, Message message, List<Property> properties, Throwable t) {
        super(loggerName, marker, loggerFQCN, level, message, properties, t);
    }

    public StackTraceElement getSource() {
        if (this.source != null) {
            return this.source;
        }
        if (this.getLoggerFqcn() == null || !this.isIncludeLocation()) {
            return null;
        }
        this.source = DWExtendedLogEvent.calcLocation(this.getLoggerFqcn());
        return this.source;
    }

    private static StackTraceElement calcLocation(String fqcnOfLogger) {
        if (fqcnOfLogger == null) {
            return null;
        }
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StackTraceElement last = null;
        for (int i = stackTrace.length - 1; i > 0; --i) {
            String className = stackTrace[i].getClassName();
            if (slf4jJclLoggerFQCN.equals(className)) {
                return last;
            }
            if (dwExtendedLoggerFQCN.equals(className)) {
                return last;
            }
            if (fqcnOfLogger.equals(className)) {
                return last;
            }
            last = stackTrace[i];
        }
        return last;
    }
}

