/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log;

import com.digiwin.app.common.config.remote.listener.DWConfigFileChangeEvent;
import com.digiwin.app.common.config.remote.listener.DWConfigFileChangeListener;
import com.digiwin.app.log.ConfigurationUpdater;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Log4j2FileChangeListener
implements DWConfigFileChangeListener {
    private static Log log = LogFactory.getLog(Log4j2FileChangeListener.class);

    private boolean updateConfigurationSource(String configurationSourceString) {
        try {
            ConfigurationUpdater.execute(configurationSourceString);
            return true;
        }
        catch (Exception e) {
            String stackTrace = this.getStackTrace(e);
            log.error((Object)("log4j update failed, stack trace = " + stackTrace));
            return false;
        }
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String stackTrace = stringWriter.toString();
        return stackTrace;
    }

    public void onChange(DWConfigFileChangeEvent event) {
        log.info((Object)"new remote log4j2.xml received!!");
        String newValue = event.getNewValue();
        String oldValue = event.getOldValue();
        if (this.updateConfigurationSource(newValue)) {
            return;
        }
        log.error((Object)"rollback log4j setting!!");
        if (this.updateConfigurationSource(oldValue)) {
            return;
        }
        log.error((Object)"rollback log4j failed");
    }
}

