/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.vo;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.log.operation.annotation.DWLogOperation;
import com.digiwin.app.log.operation.concurrent.DWLogOperationWorker;
import com.digiwin.app.log.operation.context.DWLogOperationContext;
import com.digiwin.app.log.operation.utils.DWLogOperationDataHelper;
import com.digiwin.app.log.operation.vo.DWLogAbstractOperationVo;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DWLogOperationErrorVo
extends DWLogAbstractOperationVo {
    private MethodInvocation invocation;
    private long timeConsume;
    private Throwable throwable;
    private static int stringMaxLength = 1000;

    public DWLogOperationErrorVo(MethodInvocation invocation, long timeConsume, Throwable throwable) {
        this.invocation = invocation;
        this.timeConsume = timeConsume;
        this.throwable = throwable;
        this.setOpMainLogId(DWLogOperationDataHelper.generateLogId());
        this.setTargetTableName("dw_log_operation_error");
    }

    @Override
    public Object getData() {
        return this.filterData(this.invocation, this.timeConsume, this.throwable);
    }

    public Object filterData(MethodInvocation invocation, long timeConsume, Object throwable) {
        HashMap<String, Object> rowErrorDataMap = new HashMap<String, Object>();
        try {
            Method method = invocation.getMethod();
            DWLogOperation dwLogOperationAnnotation = method.getAnnotation(DWLogOperation.class);
            DWLogOperationContext operationContext = DWLogOperationWorker.getContext();
            String log_id = this.getOpMainLogId();
            rowErrorDataMap.put("log_id", log_id);
            rowErrorDataMap.put("traceid", operationContext.getTraceId());
            rowErrorDataMap.put("operate_desc", dwLogOperationAnnotation.desc());
            rowErrorDataMap.put("module", operationContext.getModuleName());
            rowErrorDataMap.put("client_ip", operationContext.getClientIp());
            rowErrorDataMap.put("url", operationContext.getServiceUrl());
            rowErrorDataMap.put("input_value", DWLogOperationDataHelper.getParameterData(invocation.getArguments()));
            rowErrorDataMap.put("time_consume", String.valueOf(timeConsume));
            rowErrorDataMap.put("method", method.getName());
            rowErrorDataMap.put("error_message", DWLogOperationErrorVo.getErrorValueReadableData((Throwable)throwable));
            rowErrorDataMap.put("prog_impl", method.getDeclaringClass().getName() + "." + method.getName());
            rowErrorDataMap.put("$state", "C");
            rowErrorDataMap.put("create_name", operationContext.getCreateUserName());
            Map<String, Object> operateLogMap = operationContext.getOperateLog();
            if (operateLogMap != null) {
                if (operateLogMap.containsKey("operateType")) {
                    rowErrorDataMap.put("operate_type", operateLogMap.get("operateType"));
                }
                if (operateLogMap.containsKey("operateMenu")) {
                    rowErrorDataMap.put("menu", operateLogMap.get("operateMenu"));
                }
            }
            if (throwable != null && throwable instanceof DWBusinessException) {
                rowErrorDataMap.put("error_type", "2");
            } else {
                rowErrorDataMap.put("error_type", "1");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowErrorDataMap;
    }

    public static Object getErrorValueReadableData(Throwable result) {
        if (result == null) {
            return result;
        }
        String returnValue = StringUtils.abbreviate((String)ExceptionUtils.getStackTrace((Throwable)result), (int)stringMaxLength);
        return returnValue;
    }
}

