/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log;

import com.digiwin.app.log.DWLoggerContext;
import com.digiwin.app.log.DWLoggerContextFactory;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Logger;

public class DWExtendedLogger
extends Logger
implements Log {
    private static final long serialVersionUID = 1L;
    private String name = "";

    public DWExtendedLogger(String name) {
        super(DWLoggerContext.getContext(), name, null);
        this.name = name;
    }

    public void setLogFactory(LogFactory logFactory) {
    }

    public void debug(Object message) {
        this.logIfEnabled(null, Level.DEBUG, null, String.valueOf(message));
    }

    public void debug(Object message, Throwable t) {
        this.logIfEnabled(null, Level.DEBUG, null, message, t);
    }

    public void error(Object message) {
        this.logIfEnabled(null, Level.ERROR, null, String.valueOf(message));
    }

    public void error(Object message, Throwable t) {
        this.logIfEnabled(null, Level.ERROR, null, message, t);
    }

    public void fatal(Object message) {
        this.logIfEnabled(null, Level.FATAL, null, String.valueOf(message));
    }

    public void fatal(Object message, Throwable t) {
        this.logIfEnabled(null, Level.FATAL, null, message, t);
    }

    public void info(Object message) {
        if (message instanceof Map) {
            this.logIfEnabled(null, Level.INFO, null, message, null);
        } else {
            this.logIfEnabled(null, Level.INFO, null, String.valueOf(message));
        }
    }

    public void info(Object message, Throwable t) {
        this.logIfEnabled(null, Level.INFO, null, message, t);
    }

    public void trace(Object message) {
        this.logIfEnabled(null, Level.TRACE, null, String.valueOf(message));
    }

    public void trace(Object message, Throwable t) {
        this.logIfEnabled(null, Level.TRACE, null, message, t);
    }

    public void warn(Object message) {
        this.logIfEnabled(null, Level.WARN, null, String.valueOf(message));
    }

    public void warn(Object message, Throwable t) {
        this.logIfEnabled(null, Level.WARN, null, message, t);
    }

    public boolean isFatalEnabled() {
        return DWLoggerContext.getContext().getLogger(this.name).isFatalEnabled();
    }

    public boolean isErrorEnabled() {
        return DWLoggerContext.getContext().getLogger(this.name).isErrorEnabled();
    }

    public boolean isWarnEnabled() {
        return DWLoggerContext.getContext().getLogger(this.name).isWarnEnabled();
    }

    public boolean isInfoEnabled() {
        return DWLoggerContext.getContext().getLogger(this.name).isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return DWLoggerContext.getContext().getLogger(this.name).isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return DWLoggerContext.getContext().getLogger(this.name).isTraceEnabled();
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Throwable t) {
        if (!DWLoggerContextFactory.isSettingDone()) {
            return;
        }
        this.doLog(level, message, t);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message) {
        if (!DWLoggerContextFactory.isSettingDone()) {
            return;
        }
        this.doLog(level, message);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, Object message, Throwable t) {
        if (!DWLoggerContextFactory.isSettingDone()) {
            return;
        }
        this.doLog(level, message, t);
    }

    private void doLog(Level level, String message, Throwable t) {
        if (!DWLoggerContextFactory.isSettingDone()) {
            return;
        }
        Logger logger = DWLoggerContext.getContext().getLogger(this.name);
        if (!Level.OFF.equals((Object)level)) {
            if (Level.FATAL.equals((Object)level)) {
                logger.fatal(message, t);
            } else if (Level.ERROR.equals((Object)level)) {
                logger.error(message, t);
            } else if (Level.WARN.equals((Object)level)) {
                logger.warn(message, t);
            } else if (Level.INFO.equals((Object)level)) {
                logger.info(message, t);
            } else if (Level.DEBUG.equals((Object)level)) {
                logger.debug(message, t);
            } else if (Level.TRACE.equals((Object)level)) {
                logger.trace(message, t);
            } else if (Level.ALL.equals((Object)level)) {
                // empty if block
            }
        }
    }

    private void doLog(Level level, String message) {
        if (!DWLoggerContextFactory.isSettingDone()) {
            return;
        }
        Logger logger = DWLoggerContext.getContext().getLogger(this.name);
        if (!Level.OFF.equals((Object)level)) {
            if (Level.FATAL.equals((Object)level)) {
                logger.fatal(message);
            } else if (Level.ERROR.equals((Object)level)) {
                logger.error(message);
            } else if (Level.WARN.equals((Object)level)) {
                logger.warn(message);
            } else if (Level.INFO.equals((Object)level)) {
                logger.info(message);
            } else if (Level.DEBUG.equals((Object)level)) {
                logger.debug(message);
            } else if (Level.TRACE.equals((Object)level)) {
                logger.trace(message);
            } else if (Level.ALL.equals((Object)level)) {
                // empty if block
            }
        }
    }

    private void doLog(Level level, Object message, Throwable t) {
        if (!DWLoggerContextFactory.isSettingDone()) {
            return;
        }
        Logger logger = DWLoggerContext.getContext().getLogger(this.name);
        if (!Level.OFF.equals((Object)level)) {
            if (Level.FATAL.equals((Object)level)) {
                logger.fatal(message, t);
            } else if (Level.ERROR.equals((Object)level)) {
                logger.error(message, t);
            } else if (Level.WARN.equals((Object)level)) {
                logger.warn(message, t);
            } else if (Level.INFO.equals((Object)level)) {
                logger.info(message, t);
            } else if (Level.DEBUG.equals((Object)level)) {
                logger.debug(message, t);
            } else if (Level.TRACE.equals((Object)level)) {
                logger.trace(message, t);
            } else if (Level.ALL.equals((Object)level)) {
                // empty if block
            }
        }
    }

    public String toString() {
        return this.name;
    }

    public Level getLevel() {
        return DWLoggerContext.getContext().getLogger(this.name).getLevel();
    }
}

