/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.utils;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.log.utils.DWLogAppenderUtil;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.sql.transaction.seata.DWSeataUtils;
import com.digiwin.utils.DWTenantUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;

public class DWLogUtils {
    private static String _CLASSTAG = DWLogUtils.class.getSimpleName();
    private static String IAM_TENANTSIDKEY = DWTenantUtils.getIAMTenantSidKey();
    private static String IAM_TENANTIDKEY = DWTenantUtils.getIamTenantIdKey();
    private static String logTenantSidKey = DWApplicationConfigUtils.getProperty((String)"tenantColumnname", (String)"tenantsid");
    public static String logLocalHostIpName = DWLogUtils.getLocalHostIpName();
    private static Log logLogger = LogFactory.getLog((String)"com.digiwin.dwsys.service.impl.LogLogger");
    private static Log traceLogger = LogFactory.getLog((String)"com.digiwin.dwsys.service.impl.TraceLogger");
    private static MongoClient logsMongoClient;
    private static MongoDatabase logsMongoDatabase;
    private static MongoCollection<BasicDBObject> logsCollection;

    private DWLogUtils() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        DWLogUtils.initLogsMongoDB();
    }

    public static void writeLogLog(String level, Map<String, Object> logMap) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, Exception {
        DWLogUtils.writeLog(logLogger, level, logMap);
    }

    public static void writeLogLog(String level, String message) throws IllegalArgumentException {
        DWLogUtils.writeLog(logLogger, level, message);
    }

    public static void writeTraceLog(String level, Map<String, Object> logMap) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, Exception {
        DWLogUtils.writeLog(traceLogger, level, logMap);
    }

    private static void writeLog(Log logger, String level, String message) throws IllegalArgumentException {
        String capitalLevel;
        switch (capitalLevel = level.toUpperCase()) {
            case "DEBUG": {
                logger.debug((Object)message);
                break;
            }
            case "INFO": {
                logger.info((Object)message);
                break;
            }
            case "WARN": {
                logger.warn((Object)message);
                break;
            }
            case "ERROR": {
                logger.error((Object)message);
                break;
            }
            case "FATAL": {
                logger.fatal((Object)message);
                break;
            }
            default: {
                String errorMsg = String.format("level [%s] illegal!", level);
                throw new IllegalArgumentException(errorMsg);
            }
        }
    }

    private static void writeLog(Log logger, String level, Map<String, Object> logMap) throws IllegalArgumentException, Exception, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String capitalLevel;
        switch (capitalLevel = level.toUpperCase()) {
            case "DEBUG": {
                logger.debug(logMap);
                break;
            }
            case "INFO": {
                logger.info(logMap);
                break;
            }
            case "WARN": {
                logger.warn(logMap);
                break;
            }
            case "ERROR": {
                logger.error(logMap);
                break;
            }
            case "FATAL": {
                logger.fatal(logMap);
                break;
            }
            default: {
                String errorMsg = String.format("level [%s] illegal!", level);
                throw new IllegalArgumentException(errorMsg);
            }
        }
    }

    public static Map<String, Object> initLogMap(Map<String, Object> logMap) {
        String traceId;
        DWServiceContext dwServiceContext = DWServiceContext.getContext();
        Map profile = dwServiceContext.getProfile();
        if (!logMap.containsKey(logTenantSidKey) && profile != null && profile.containsKey(IAM_TENANTSIDKEY)) {
            Long tenantsid = (Long)profile.get(IAM_TENANTSIDKEY);
            logMap.putIfAbsent(logTenantSidKey, tenantsid);
        }
        if (!logMap.containsKey(IAM_TENANTIDKEY) && profile != null && profile.containsKey(IAM_TENANTIDKEY)) {
            String tenantid = (String)profile.get(IAM_TENANTIDKEY);
            logMap.putIfAbsent(IAM_TENANTIDKEY, tenantid);
        }
        if (!logMap.containsKey("traceId") && StringUtils.isNotBlank((CharSequence)(traceId = dwServiceContext.getTraceId()))) {
            logMap.putIfAbsent("traceId", traceId);
        }
        return logMap;
    }

    public static Map<String, String> initLogMap2(Map<String, String> logMap) {
        String traceId;
        DWServiceContext dwServiceContext = DWServiceContext.getContext();
        Map profile = dwServiceContext.getProfile();
        if (!logMap.containsKey(logTenantSidKey) && profile != null && profile.containsKey(IAM_TENANTSIDKEY)) {
            String tenantsid = String.valueOf((Long)profile.get(IAM_TENANTSIDKEY));
            logMap.putIfAbsent(logTenantSidKey, tenantsid);
        }
        if (!logMap.containsKey(IAM_TENANTIDKEY) && profile != null && profile.containsKey(IAM_TENANTIDKEY)) {
            String tenantid = (String)profile.get(IAM_TENANTIDKEY);
            logMap.putIfAbsent(IAM_TENANTIDKEY, tenantid);
        }
        if (!logMap.containsKey("traceId") && StringUtils.isNotBlank((CharSequence)(traceId = dwServiceContext.getTraceId()))) {
            logMap.putIfAbsent("traceId", traceId);
        }
        return logMap;
    }

    public static Map<String, Object> filterEventContextMap(Map<String, String> contextDataMap, List<String> tracerKeysList) {
        String contextValue;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String contextKey : contextDataMap.keySet()) {
            if (tracerKeysList != null && (tracerKeysList == null || !tracerKeysList.contains(contextKey))) continue;
            result.put(contextKey, contextDataMap.get(contextKey));
        }
        if (result != null && result.size() > 0 && result.containsKey(logTenantSidKey) && NumberUtils.isDigits((String)(contextValue = (String)result.get(logTenantSidKey)))) {
            result.replace(logTenantSidKey, Long.valueOf(contextValue));
        }
        return result;
    }

    public static Map<String, Object> afterLogMap(Map<String, Object> logMap) {
        logMap.putIfAbsent("server", DWLogUtils.getLocalHostIpName());
        return logMap;
    }

    public static String getLocalHostIpName() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            System.out.println(_CLASSTAG + " UnknownHostException:" + e.getLocalizedMessage());
        }
        String ip = addr.getHostAddress().toString();
        String hostName = addr.getHostName().toString();
        String result = hostName == null || hostName == "" ? ip : hostName;
        return result;
    }

    public static String getLogTenantSidKey() {
        return logTenantSidKey;
    }

    public static void setLogTenantSidKey(String logTenantSidKey) {
        DWLogUtils.logTenantSidKey = logTenantSidKey;
    }

    private static void initLogsMongoDB() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (logsMongoDatabase == null) {
            logsMongoDatabase = DWLogAppenderUtil.getLogsMongoDatabase();
        }
    }

    public static String getTraceId() {
        String traceId = "";
        String contextTraceId = ThreadContext.get((String)"traceId");
        traceId = StringUtils.isBlank((CharSequence)contextTraceId) ? DWLogUtils.getUUID() : contextTraceId;
        return traceId;
    }

    private static String getUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().replaceAll("-", "");
    }

    public static String getDistributedTransactionId() {
        return DWSeataUtils.getDtxId();
    }

    public static void setDistributedTransactionId(String xid) {
        DWSeataUtils.setDtxId((String)xid);
    }

    public static boolean getSeataEnabled() {
        return DWSeataUtils.getSeataEnabled();
    }
}

