/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.utils;

import com.digiwin.app.log.ConfigurationUpdater;
import com.digiwin.app.log.DWLoggerContext;
import com.digiwin.app.log.DWLoggerContextFactory;
import com.mongodb.BasicDBObject;
import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;

public class DWLogAppenderUtil {
    private static MongoClient logsMongoClient;
    private static MongoDatabase logsMongoDatabase;
    private static MongoCollection<BasicDBObject> logsCollection;
    private static MongoClient tracesMongoClient;
    private static MongoDatabase tracesMongoDatabase;
    private static MongoCollection<BasicDBObject> tracesCollection;

    public static void initLogsMongoDB() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (logsMongoDatabase == null) {
            Appender mongoAppender;
            Class<?> clazz = Class.forName("com.digiwin.app.log.appender.DwMongoDBAppender");
            Method getConnMethod = clazz.getMethod("getConnectionUrl", new Class[0]);
            Method getDBNameMethod = clazz.getMethod("getDatabaseName", new Class[0]);
            Method getColNameMethod = clazz.getMethod("getCollectionName", new Class[0]);
            if (DWLoggerContextFactory.isSettingDone()) {
                Logger logger = DWLoggerContext.getContext().getLogger(ConfigurationUpdater.class.getName());
                Configuration config = logger.getContext().getConfiguration();
                mongoAppender = (Appender)config.getAppenders().get("logServiceLogAppender");
            } else {
                mongoAppender = DWLogAppenderUtil.getOtherAppender("logServiceLogAppender");
            }
            String connectionUrl = (String)getConnMethod.invoke((Object)mongoAppender, new Object[0]);
            String dbName = (String)getDBNameMethod.invoke((Object)mongoAppender, new Object[0]);
            String colName = (String)getColNameMethod.invoke((Object)mongoAppender, new Object[0]);
            logsMongoClient = MongoClients.create((ConnectionString)new ConnectionString(connectionUrl));
            logsMongoDatabase = logsMongoClient.getDatabase(dbName);
            logsCollection = logsMongoDatabase.getCollection(colName, BasicDBObject.class);
        }
    }

    public static void initTracesMongoDB() throws Exception {
        if (tracesMongoDatabase == null) {
            Appender mongoAppender = DWLogAppenderUtil.getOtherAppender("logServiceTraceAppender");
            Class<?> clazz = Class.forName("com.digiwin.app.log.appender.DwMongoDBAppender");
            Method getConnMethod = clazz.getMethod("getConnectionUrl", new Class[0]);
            Method getDBNameMethod = clazz.getMethod("getDatabaseName", new Class[0]);
            Method getColNameMethod = clazz.getMethod("getCollectionName", new Class[0]);
            String connectionUrl = (String)getConnMethod.invoke((Object)mongoAppender, new Object[0]);
            String dbName = (String)getDBNameMethod.invoke((Object)mongoAppender, new Object[0]);
            String colName = (String)getColNameMethod.invoke((Object)mongoAppender, new Object[0]);
            tracesMongoClient = MongoClients.create((ConnectionString)new ConnectionString(connectionUrl));
            tracesMongoDatabase = tracesMongoClient.getDatabase(dbName);
            tracesCollection = tracesMongoDatabase.getCollection(colName, BasicDBObject.class);
        }
    }

    public static MongoDatabase getLogsMongoDatabase() {
        return logsMongoDatabase;
    }

    public static MongoCollection<BasicDBObject> getLogsCollection() throws Exception {
        if (logsCollection == null) {
            DWLogAppenderUtil.initLogsMongoDB();
        }
        return logsCollection;
    }

    public static MongoClient getTracesMongoClient() {
        return tracesMongoClient;
    }

    public static MongoDatabase getTracesMongoDatabase() {
        return tracesMongoDatabase;
    }

    public static MongoCollection<BasicDBObject> getTracesCollection() throws Exception {
        if (tracesCollection == null) {
            DWLogAppenderUtil.initTracesMongoDB();
        }
        return tracesCollection;
    }

    public static Appender getOtherAppender(String loggerName) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        Appender appender = config.getAppender(loggerName);
        return appender;
    }
}

