/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata.loader;

import com.digiwin.app.metadata.DWMetadata;
import com.digiwin.app.metadata.exceptions.DWMetadataException;
import com.digiwin.app.metadata.loader.DWMetadataLoader;
import java.util.HashMap;
import java.util.Map;

public final class DWMetadataLoaderManager {
    private static final Map<Class<? extends DWMetadata<?>>, DWMetadataLoader<?>> loaders = new HashMap();

    public static synchronized void registerLoader(DWMetadataLoader<?> loader) {
        if (loader == null) {
            throw new IllegalArgumentException("loader is null!");
        }
        Class<DWMetadata<?>> metadataType = loader.getMetadataType();
        if (metadataType == null) {
            throw new IllegalArgumentException("metadataType is null!");
        }
        if (loaders.containsKey(metadataType)) {
            throw new DWMetadataException(String.format("metadata type(%s)'s loader has already been registered!", new Object[0]));
        }
        loaders.put(metadataType, loader);
    }

    public static DWMetadata<?> load(Class<? extends DWMetadata<?>> metadataType, String name) {
        if (metadataType == null) {
            throw new IllegalArgumentException("metadataType is null!");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is null or empty!");
        }
        DWMetadataLoader<?> loader = loaders.get(metadataType);
        if (loader == null) {
            throw new DWMetadataException(String.format("metadata type(%s)'s loader not found!", metadataType.getSimpleName()));
        }
        Object metadata = loader.load(name);
        return metadata;
    }
}

