/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata.rdbms;

import com.digiwin.app.metadata.DWMetadata;
import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.DWValueAttribute;
import com.digiwin.app.metadata.exceptions.DWMetadataException;
import com.digiwin.app.metadata.rdbms.DWRdbmsAttributes;
import com.digiwin.app.metadata.rdbms.DWRdbmsField;
import java.util.ArrayList;
import java.util.Collection;

public class DWRdbmsMetadata
extends DWMetadata<DWRdbmsField> {
    private static final long serialVersionUID = 1L;
    private boolean initialized = false;
    private String versionControl = null;
    private String autoIncrement = null;

    public DWRdbmsMetadata() {
    }

    public DWRdbmsMetadata(String name) {
        super(name);
    }

    public Collection<String> getPrimaryKeys() {
        ArrayList<String> primaryKeys = new ArrayList<String>(){

            @Override
            public boolean contains(Object o) {
                if (o == null) {
                    for (int i = 0; i < this.size(); ++i) {
                        if (this.get(i) != null) continue;
                        return true;
                    }
                } else {
                    for (int i = 0; i < this.size(); ++i) {
                        if ((!(o instanceof String) || !(this.get(i) instanceof String) || !((String)o).equalsIgnoreCase((String)this.get(i))) && !o.equals(this.get(i))) continue;
                        return true;
                    }
                }
                return false;
            }
        };
        for (DWRdbmsField field : this.getFields()) {
            if (!field.isPrimaryKey()) continue;
            primaryKeys.add(field.getName());
        }
        return primaryKeys;
    }

    public String getVersionControl() {
        this.initialize();
        return this.versionControl;
    }

    public String getAutoIncrement() {
        this.initialize();
        return this.autoIncrement;
    }

    private void initialize() {
        if (!this.initialized) {
            String verControlName = null;
            String autoIncrementName = null;
            for (DWRdbmsField field : this.getFields()) {
                if (field.hasAttribute(DWRdbmsAttributes.RDBMS_VERSION_CONTROL)) {
                    if (verControlName != null) {
                        throw new DWMetadataException("There are more than one version control fields!");
                    }
                    verControlName = field.getName();
                }
                if (!field.hasAttribute(DWRdbmsAttributes.RDBMS_AUTO_INCREMENT)) continue;
                if (autoIncrementName != null) {
                    throw new DWMetadataException("There are more than one auto increment fields!");
                }
                autoIncrementName = field.getName();
            }
            this.versionControl = verControlName;
            this.autoIncrement = autoIncrementName;
            this.initialized = false;
        }
    }

    public Object getTableDisplayName() {
        return this.getAttribute(DWRdbmsAttributes.RDBMS_TABLE_DISPLAYNAME);
    }

    public Object getTableDescription() {
        return this.getAttribute(DWRdbmsAttributes.RDBMS_TABLE_DESCRIPTION);
    }

    public String getHintField() {
        DWValueAttribute hintFieldthis = (DWValueAttribute)this.getAttribute(DWRdbmsAttributes.RDBMS_HINTFIELD);
        return (String)hintFieldthis.getValue();
    }

    private String getDeleteConstraint() {
        DWValueAttribute deleteConstraint = (DWValueAttribute)this.getAttribute(DWRdbmsAttributes.RDBMS_DELETECONSTRAINT);
        return (String)deleteConstraint.getValue();
    }

    public static Boolean hasConstraint(String tableName) {
        DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get(tableName, DWRdbmsMetadata.class);
        String deleteConstraint = metadata.getDeleteConstraint();
        return DWRdbmsMetadata.BooleanConverter(deleteConstraint);
    }

    private static Boolean BooleanConverter(String deleteConstraint) {
        Boolean haveDeleteConstraint = false;
        if (deleteConstraint.equalsIgnoreCase("y")) {
            haveDeleteConstraint = true;
        }
        return haveDeleteConstraint;
    }
}

