/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata;

import com.digiwin.app.metadata.DWAttribute;
import com.digiwin.app.metadata.DWAttributeCollection;
import com.digiwin.app.metadata.DWField;
import com.digiwin.app.metadata.exceptions.DWFieldNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DWMetadata<T extends DWField>
implements Serializable {
    private String name;
    private DWAttributeCollection attributes = new DWAttributeCollection();
    private List<T> fields = new ArrayList<T>();

    public DWMetadata() {
    }

    public DWMetadata(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is null or empty!");
        }
        this.name = name;
        this.attributes = new DWAttributeCollection();
    }

    public DWMetadata(String name, String programNo) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is null or empty!");
        }
        if (programNo == null || programNo.isEmpty()) {
            throw new IllegalArgumentException("programNo is null or empty!");
        }
        this.name = name;
        this.attributes = new DWAttributeCollection();
    }

    public String getName() {
        return this.name;
    }

    public void addField(T field) {
        if (field == null) {
            throw new IllegalArgumentException("field is null!");
        }
        this.fields.add(field);
    }

    public T tryGetField(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null!");
        }
        name = name.toLowerCase();
        for (DWField field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return (T)field;
        }
        return null;
    }

    public T getField(String name) {
        T field = this.tryGetField(name);
        if (field == null) {
            throw new DWFieldNotFoundException(name);
        }
        return field;
    }

    public boolean hasField(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null!");
        }
        String lowerCaseName = name.toLowerCase();
        boolean any = this.fields.stream().anyMatch(f -> f.getName().equals(lowerCaseName));
        return any;
    }

    public List<T> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public void setName(String name) {
        this.name = name;
    }

    public <T extends DWAttribute> Collection<T> getAttributes(Class<? extends DWAttribute> dwAttributeType) {
        return this.attributes.getAttributes(dwAttributeType);
    }

    public <T extends DWAttribute> T getAttribute(String attributeName) {
        return this.attributes.getAttribute(attributeName);
    }

    public void addAttribute(DWAttribute ... attributes) {
        this.attributes.addAttribute(attributes);
    }
}

