/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata.rdbms;

import com.digiwin.app.metadata.rdbms.DWRdbmsField;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.app.metadata.rdbms.DWRdbmsOneToManyField;

public final class DWRdbmsUtils {
    public static DWRdbmsMetadata createMetadata(String name) {
        DWRdbmsMetadata metadata = new DWRdbmsMetadata(name);
        return metadata;
    }

    public static DWRdbmsMetadata createMetadata(String name, DWRdbmsField ... fields) {
        DWRdbmsMetadata metadata = new DWRdbmsMetadata(name);
        for (DWRdbmsField field : fields) {
            metadata.addField(field);
        }
        return metadata;
    }

    public static DWRdbmsField createStringField(String name, int size, String defaultValue) {
        return new DWRdbmsField(name, "STRING", size, 0, defaultValue);
    }

    public static DWRdbmsField createStringField(String name, int size, boolean nullable, String defaultValue) {
        return new DWRdbmsField(name, "STRING", size, 0, nullable, defaultValue);
    }

    public static DWRdbmsField createStringField(String name, int size, boolean nullable, boolean primaryKey, String defaultValue) {
        return new DWRdbmsField(name, "STRING", size, 0, nullable, primaryKey, defaultValue);
    }

    public static DWRdbmsField createIntegerField(String name, int size, String defaultValue) {
        return new DWRdbmsField(name, "INT", size, 0, defaultValue);
    }

    public static DWRdbmsField createIntegerField(String name, int size, boolean nullable, boolean primaryKey, String defaultValue) {
        return DWRdbmsUtils.createIntegerField(name, size, nullable, primaryKey, false, defaultValue);
    }

    public static DWRdbmsField createIntegerField(String name, int size, boolean nullable, boolean primaryKey, boolean versionControll, String defaultValue) {
        return new DWRdbmsField(name, "INT", size, 0, nullable, primaryKey, versionControll, defaultValue);
    }

    public static DWRdbmsField createDecimalField(String name, int size, boolean nullable, int scale, String defaultValue) {
        return new DWRdbmsField(name, "DECIMAL", size, scale, nullable, defaultValue);
    }

    public static DWRdbmsField createDateField(String name, String defaultValue) {
        return new DWRdbmsField(name, "DATE", defaultValue);
    }

    public static DWRdbmsField createDateField(String name, boolean nullable, String defaultValue) {
        return new DWRdbmsField(name, "DATE", nullable, defaultValue);
    }

    public static DWRdbmsField createDateField(String name, boolean nullable, boolean primaryKey, String defaultValue) {
        return new DWRdbmsField(name, "DATE", nullable, primaryKey, defaultValue);
    }

    public static DWRdbmsField createDatetimeField(String name, String defaultValue) {
        return new DWRdbmsField(name, "DATETIME", defaultValue);
    }

    public static DWRdbmsField createDatetimeField(String name, boolean nullable, String defaultValue) {
        return new DWRdbmsField(name, "DATETIME", nullable, defaultValue);
    }

    public static DWRdbmsField createDatetimeField(String name, boolean nullable, boolean primaryKey, String defaultValue) {
        return new DWRdbmsField(name, "DATETIME", nullable, primaryKey, defaultValue);
    }

    public static DWRdbmsField createBooleanField(String name, String defaultValue) {
        return new DWRdbmsField(name, "BOOLEAN", defaultValue);
    }

    public static DWRdbmsField createJsonField(String name, int size, boolean nullable, boolean primaryKey, String defaultValue) {
        return new DWRdbmsField(name, "JSON", size, 0, nullable, primaryKey, defaultValue);
    }

    @Deprecated
    public static DWRdbmsOneToManyField createOneToManyField(String detailTableName) {
        return new DWRdbmsOneToManyField(detailTableName, detailTableName);
    }

    @Deprecated
    public static DWRdbmsOneToManyField createOneToManyField(String name, String detailTableName) {
        return new DWRdbmsOneToManyField(name, detailTableName);
    }
}

