/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.actuate;

import java.util.ArrayList;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;

public class DWModuleHealthIndicatorConfigurationImportSelector
implements ImportSelector {
    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        String neo4jHealthIndicatorConfiguration;
        ArrayList<String> configs = new ArrayList<String>();
        configs.add("com.digiwin.app.autoconfigure.actuate.jdbc.DWModuleLayerDataSourceHealthIndicatorConfiguration");
        configs.add("com.digiwin.app.autoconfigure.actuate.amqp.DWModuleLayerRabbitHealthIndicatorConfiguration");
        configs.add("com.digiwin.app.autoconfigure.actuate.redis.DWModuleLayerRedisHealthIndicatorConfiguration");
        String mongoHealthIndicatorConfiguration = "com.digiwin.app.autoconfigure.actuate.mongo.DWModuleLayerMongoHealthIndicatorConfiguration";
        if (this.canTouchConditionalOnClassAnnotation(mongoHealthIndicatorConfiguration)) {
            configs.add(mongoHealthIndicatorConfiguration);
        }
        if (this.canTouchConditionalOnClassAnnotation(neo4jHealthIndicatorConfiguration = "com.digiwin.app.autoconfigure.actuate.neo4j.DWModuleLayerNeo4jHealthIndicatorConfiguration")) {
            configs.add(neo4jHealthIndicatorConfiguration);
        }
        return (String[])configs.stream().toArray(String[]::new);
    }

    private boolean canTouchConditionalOnClassAnnotation(String className) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass(className);
            clazz.getAnnotation(ConditionalOnClass.class);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

