/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata.redis;

import com.digiwin.app.metadata.redis.AbstractRedisPoolMetadata;
import java.util.Collection;
import java.util.Objects;
import org.redisson.Redisson;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.util.CollectionUtils;

public class RedissonConnectionFactoryPoolMetadata
extends AbstractRedisPoolMetadata<RedissonConnectionFactory> {
    public RedissonConnectionFactoryPoolMetadata(RedissonConnectionFactory redisConnectionFactory) {
        super(redisConnectionFactory);
    }

    @Override
    public Integer getcurrent() {
        Redisson redisson = this.getRedisson();
        ConnectionManager connectionManager = redisson.getConnectionManager();
        Collection entrySet = connectionManager.getEntrySet();
        if (!CollectionUtils.isEmpty((Collection)entrySet)) {
            MasterSlaveEntry[] masterSlaveEntrieArray = new MasterSlaveEntry[entrySet.size()];
            entrySet.toArray(masterSlaveEntrieArray);
            if (masterSlaveEntrieArray[0].getAllEntries().size() > 0) {
                ClientConnectionsEntry[] connectionsEntries = new ClientConnectionsEntry[masterSlaveEntrieArray[0].getAllEntries().size()];
                masterSlaveEntrieArray[0].getAllEntries().toArray(connectionsEntries);
                return connectionsEntries[0].getAllConnections().size();
            }
        }
        return null;
    }

    @Override
    public Integer getMax() {
        SingleServerConfig singleServerConfig = this.getSingleServerConfig();
        if (Objects.nonNull(singleServerConfig)) {
            return singleServerConfig.getConnectionPoolSize();
        }
        return null;
    }

    @Override
    public Integer getMin() {
        SingleServerConfig singleServerConfig = this.getSingleServerConfig();
        if (Objects.nonNull(singleServerConfig)) {
            return singleServerConfig.getConnectionMinimumIdleSize();
        }
        return null;
    }

    private SingleServerConfig getSingleServerConfig() {
        Redisson redisson = this.getRedisson();
        Config config = null;
        if (Objects.nonNull(redisson)) {
            config = redisson.getConfig();
        }
        if (Objects.nonNull(config)) {
            return (SingleServerConfig)new DirectFieldAccessor((Object)config).getPropertyValue("singleServerConfig");
        }
        return null;
    }

    private Redisson getRedisson() {
        Redisson redisson = (Redisson)new DirectFieldAccessor(this.getRedisConnectionFactory()).getPropertyValue("redisson");
        return redisson;
    }
}

