/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.actuate;

import com.digiwin.app.actuate.DWAbstractModuleBeanHealthIndicatorProcessor;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.spring.SpringContextUtils;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;

public class DWModuleHealthIndicatorContainerBeanPostProcessor
implements BeanPostProcessor {
    private List<DWAbstractModuleBeanHealthIndicatorProcessor> processors;
    private Map<String, HealthIndicator> indicators;
    private HealthAggregator aggregator;

    public DWModuleHealthIndicatorContainerBeanPostProcessor(CompositeHealthIndicator rootIndicator, List<DWAbstractModuleBeanHealthIndicatorProcessor> processors) throws Exception {
        if (rootIndicator == null) {
            this.processors = Collections.emptyList();
        } else {
            Field indicatorsField = CompositeHealthIndicator.class.getDeclaredField("indicators");
            indicatorsField.setAccessible(true);
            this.indicators = (Map)indicatorsField.get(rootIndicator);
            Field aggregatorField = CompositeHealthIndicator.class.getDeclaredField("healthAggregator");
            aggregatorField.setAccessible(true);
            this.aggregator = (HealthAggregator)aggregatorField.get(rootIndicator);
            this.processors = processors;
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        DWAbstractModuleBeanHealthIndicatorProcessor targetProcessor = null;
        for (int i = 0; i < this.processors.size(); ++i) {
            DWAbstractModuleBeanHealthIndicatorProcessor processor = this.processors.get(i);
            if (!processor.accept(bean)) continue;
            targetProcessor = processor;
            break;
        }
        if (targetProcessor != null) {
            Object subIndicator = targetProcessor.createHealthIndicator(bean);
            String moduleName = DWModuleClassLoader.getCurrentModuleName();
            String indicatorName = moduleName == null ? beanName : "[" + moduleName + "]." + beanName;
            this.addSubHealthIndicator(targetProcessor.getIndicatorName(), indicatorName, (HealthIndicator)subIndicator, targetProcessor.getTargetBeanType());
        }
        return bean;
    }

    private void addSubHealthIndicator(String groupIndicatorName, String subIndicatorName, HealthIndicator subIndicator, Class<?> targetClass) {
        HealthIndicator mappingIndicator;
        CompositeHealthIndicator compositeHealthIndicator = null;
        HealthIndicator healthIndicator = mappingIndicator = this.indicators.containsKey(groupIndicatorName) ? this.indicators.get(groupIndicatorName) : null;
        if (mappingIndicator instanceof CompositeHealthIndicator) {
            compositeHealthIndicator = (CompositeHealthIndicator)mappingIndicator;
        } else {
            compositeHealthIndicator = new CompositeHealthIndicator(this.aggregator);
            this.indicators.put(groupIndicatorName, (HealthIndicator)compositeHealthIndicator);
            if (mappingIndicator != null) {
                String originIndicatorName = this.getTargetClassBeanName(targetClass, groupIndicatorName);
                compositeHealthIndicator.addHealthIndicator(originIndicatorName, mappingIndicator);
            }
        }
        compositeHealthIndicator.addHealthIndicator(subIndicatorName, subIndicator);
    }

    private String getTargetClassBeanName(Class<?> targetClass, String groupIndicatorName) {
        String beanName = null;
        String[] beanNames = SpringContextUtils.getContext().getBeanNamesForType(targetClass);
        if (beanNames != null && beanNames.length >= 1) {
            beanName = beanNames[0];
        }
        if (beanName == null) {
            beanName = "platform-layer_" + groupIndicatorName;
        }
        return beanName;
    }
}

