/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.actuate;

import com.digiwin.app.actuate.DWHealthIndicatorWrapper;
import com.digiwin.app.actuate.DWReactiveHealthIndicatorWrapper;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;

public class DWWrapHealthIndicatorBeanPostProcessor
implements BeanPostProcessor {
    private static Log log = LogFactory.getLog(DWWrapHealthIndicatorBeanPostProcessor.class);

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof HealthIndicator && !(bean instanceof DWHealthIndicatorWrapper)) {
            if (bean instanceof CompositeHealthIndicator) {
                this.wrapInnerHealthIndicator(beanName, (CompositeHealthIndicator)bean);
            }
            log.debug((Object)String.format("wrap HealthIndicator(beanName=%s, class=%s)", bean, bean.getClass().getName()));
            return new DWHealthIndicatorWrapper((HealthIndicator)bean);
        }
        if (bean instanceof ReactiveHealthIndicator && !(bean instanceof DWReactiveHealthIndicatorWrapper)) {
            log.debug((Object)String.format("wrap ReactiveHealthIndicator(beanName=%s, class=%s)", bean, bean.getClass().getName()));
            return new DWReactiveHealthIndicatorWrapper((ReactiveHealthIndicator)bean);
        }
        return bean;
    }

    private void wrapInnerHealthIndicator(String beanName, CompositeHealthIndicator compositeHealthIndicator) {
        log.debug((Object)String.format("wrap CompositeHealthIndicator(beanName=%s) inner indicators...", beanName));
        try {
            Field indicatorsField = compositeHealthIndicator.getClass().getDeclaredField("indicators");
            indicatorsField.setAccessible(true);
            LinkedHashMap wrappedMap = new LinkedHashMap();
            Map innerIndicators = (Map)indicatorsField.get(compositeHealthIndicator);
            for (Map.Entry entry : innerIndicators.entrySet()) {
                HealthIndicator healthIndicator = (HealthIndicator)entry.getValue();
                if (!(healthIndicator instanceof DWHealthIndicatorWrapper)) {
                    log.debug((Object)String.format("wrap CompositeHealthIndicator inner indicator(key=%s, class=%s)", entry.getKey(), ((HealthIndicator)entry.getValue()).getClass().getName()));
                    healthIndicator = new DWHealthIndicatorWrapper(healthIndicator);
                }
                wrappedMap.put(entry.getKey(), healthIndicator);
            }
            indicatorsField.set(compositeHealthIndicator, wrappedMap);
            innerIndicators.clear();
            log.debug((Object)String.format("wrap CompositeHealthIndicator inner indicators completed!", beanName));
        }
        catch (Exception e) {
            log.warn((Object)"wrapInnerHealthIndicator failed!", (Throwable)e);
        }
    }
}

