/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.metrics;

import com.alibaba.druid.pool.DruidDataSource;
import com.digiwin.app.autoconfigure.metrics.DWModuleLayerMetricsConfiguration;
import com.digiwin.app.metadata.datasource.DWDataSourcePoolMetadataProvider;
import com.digiwin.app.metadata.datasource.Dbcp2DataSourcePoolMetadata;
import com.digiwin.app.metadata.datasource.DuridDataSourcePoolMetadata;
import com.digiwin.app.metadata.redis.JedisConnectionFactoryPoolMetadata;
import com.digiwin.app.metadata.redis.LettuceConnectionFactoryPoolMetadata;
import com.digiwin.app.metadata.redis.RedisPoolMetadataProvider;
import com.digiwin.app.metadata.redis.RedissonConnectionFactoryPoolMetadata;
import com.digiwin.app.metrics.DWMongoListenerMetrics;
import com.digiwin.app.metrics.DWMySQLMetrics;
import com.digiwin.app.metrics.DWRedisMetrics;
import com.digiwin.app.metrics.EaiCallBackTimeOutMetrics;
import com.digiwin.app.metrics.HttpClientMetricsInterceptor;
import com.digiwin.app.metrics.QueryRunnerMetricsInterceptor;
import com.digiwin.app.metrics.RedisTemplateMetricsInterceptor;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.mongodb.MongoClientOptions;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.apache.commons.dbcp2.BasicDataSource;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, RedisAutoConfiguration.class, MongoDataAutoConfiguration.class})
@ConditionalOnClass(value={PrometheusMeterRegistry.class})
@ConditionalOnProperty(name={"dwMetricsEnabled"}, havingValue="true", matchIfMissing=true)
public class DWMetricsAutoConfiguration {
    public DWMetricsAutoConfiguration() {
        DWModuleSpringUtils.registerModuleConfigurationClass(DWModuleLayerMetricsConfiguration.class);
    }

    @Bean
    DWDataSourcePoolMetadataProvider duridDataSourcePoolMetadata() {
        return dataSource -> dataSource instanceof DruidDataSource ? new DuridDataSourcePoolMetadata((DruidDataSource)dataSource) : null;
    }

    @Bean
    DWDataSourcePoolMetadataProvider dbcp2DataSourcePoolMetadata() {
        return dataSource -> dataSource instanceof BasicDataSource ? new Dbcp2DataSourcePoolMetadata((BasicDataSource)dataSource) : null;
    }

    @Bean
    RedisPoolMetadataProvider lettuceConnectionFactoryPoolMetadataProvider() {
        return connectionFactory -> connectionFactory instanceof LettuceConnectionFactory ? new LettuceConnectionFactoryPoolMetadata((LettuceConnectionFactory)connectionFactory) : null;
    }

    @Bean
    RedisPoolMetadataProvider redissonConnectionFactoryPoolMetadataProvider() {
        return connectionFactory -> connectionFactory instanceof RedissonConnectionFactory ? new RedissonConnectionFactoryPoolMetadata((RedissonConnectionFactory)connectionFactory) : null;
    }

    @Bean
    RedisPoolMetadataProvider jedisConnectionFactoryPoolMetadataProvider() {
        return connectionFactory -> connectionFactory instanceof JedisConnectionFactory ? new JedisConnectionFactoryPoolMetadata((JedisConnectionFactory)connectionFactory) : null;
    }

    @Bean
    public Advisor queryRunnerAdvisor(QueryRunnerMetricsInterceptor queryRunnerMetricsInterceptor) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("within(org.apache.commons.dbutils.QueryRunner+) && (  execution(* batch(..)) || execution(* query(..)) || execution(* update(..)) || execution(* insert(..)) || execution(* insertBatch(..)) )");
        DefaultBeanFactoryPointcutAdvisor advisor = new DefaultBeanFactoryPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)queryRunnerMetricsInterceptor);
        return advisor;
    }

    @Bean
    public QueryRunnerMetricsInterceptor queryRunnerMetricsInterceptor(ObjectProvider<Map<String, DataSource>> dataSourceMapProvider) {
        return new QueryRunnerMetricsInterceptor((Map)dataSourceMapProvider.getIfAvailable());
    }

    @Bean
    public Advisor redisTemplateAdvisor(RedisTemplateMetricsInterceptor redisTemplateMetricsInterceptor) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("execution( * org.springframework.data.redis.core.RedisOperations.*(..))");
        DefaultBeanFactoryPointcutAdvisor advisor = new DefaultBeanFactoryPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)redisTemplateMetricsInterceptor);
        return advisor;
    }

    @Bean
    public RedisTemplateMetricsInterceptor redisTemplateMetricsInterceptor() {
        return new RedisTemplateMetricsInterceptor();
    }

    @Bean
    MongoClientOptions mongoClientOptions(DWMongoListenerMetrics dwMongoListenerMetrics) {
        return MongoClientOptions.builder().addConnectionPoolListener((ConnectionPoolListener)dwMongoListenerMetrics).addCommandListener((CommandListener)dwMongoListenerMetrics).build();
    }

    @Bean
    DWMongoListenerMetrics dwMongoListenerMetrics(MeterRegistry registry) {
        return new DWMongoListenerMetrics(registry);
    }

    @Bean
    DWRedisMetrics dwRedisMetrics(ObjectProvider<Map<String, RedisConnectionFactory>> redisConnectionFactoryProvider, ObjectProvider<List<RedisPoolMetadataProvider>> objectProvider, MeterRegistry registry) {
        return new DWRedisMetrics((Map)redisConnectionFactoryProvider.getIfAvailable(), (Collection)objectProvider.getIfAvailable(), registry);
    }

    @Bean
    DWMySQLMetrics dwMySQLMetrics(ObjectProvider<Map<String, DataSource>> dataSourceMapProvider, ObjectProvider<Collection<DWDataSourcePoolMetadataProvider>> metadataProviders, MeterRegistry registry) {
        return new DWMySQLMetrics((Map)dataSourceMapProvider.getIfAvailable(), (Collection)metadataProviders.getIfAvailable(), registry);
    }

    @Bean
    public Advisor dwHttpClientInterceptor(HttpClientMetricsInterceptor httpClientMetricInterceptor) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("within(org.apache.http.client.HttpClient+) && execution(public org.apache.http.HttpResponse execute(org.apache.http.client.methods.HttpUriRequest))");
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)httpClientMetricInterceptor);
        return advisor;
    }

    @Bean
    public HttpClientMetricsInterceptor httpClientMetricInterceptor() {
        return new HttpClientMetricsInterceptor();
    }

    @Bean
    @ConditionalOnProperty(name={"dwMetrics.eaiCallBack.alarm.enable"}, havingValue="true")
    public EaiCallBackTimeOutMetrics eaiCallBackTimeOutMetrics(MeterRegistry registry, @Value(value="${eai.callback.metrics.initial:10}") int initial, @Value(value="${eai.callback.metrics.max:20}") int max, @Value(value="${eai.callback.metrics.expire.mil:120000}") long expire) {
        return new EaiCallBackTimeOutMetrics(registry, initial, max, expire);
    }
}

