/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metrics;

import com.digiwin.app.autoconfigure.metrics.DWAbstractModuleBeanMetricsProcessor;
import com.digiwin.app.metadata.datasource.DWAbstractDataSourcePoolMetadata;
import com.digiwin.app.metadata.datasource.DWCompositeRedisPoolMetadataProvider;
import com.digiwin.app.metadata.datasource.DWDataSourcePoolMetadataProvider;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.springframework.util.ConcurrentReferenceHashMap;

public class DWMySQLMetrics
extends DWAbstractModuleBeanMetricsProcessor<DataSource> {
    private static Map<Object, String> beanMapTag = new HashMap<Object, String>();
    private MeterRegistry registry;
    DWDataSourcePoolMetadataProvider dataSourcePoolMetadataProvider;

    public DWMySQLMetrics(Map<String, DataSource> dataSourceMap, Collection<DWDataSourcePoolMetadataProvider> metadataProviders, MeterRegistry registry) {
        this.registry = registry;
        this.dataSourcePoolMetadataProvider = new CachingDataSourcePoolMetadataProvider(new DWCompositeRedisPoolMetadataProvider(metadataProviders));
        if (Objects.nonNull(dataSourceMap)) {
            dataSourceMap.forEach((beanName, bean) -> {
                DataSource realBean = (DataSource)this.getRealBean(bean);
                if (!beanMapTag.containsKey(bean)) {
                    beanMapTag.put(realBean, (String)beanName);
                    this.registry(realBean);
                }
            });
        }
    }

    private DWAbstractDataSourcePoolMetadata getDataSourceMetadata(DataSource dataSource) {
        return this.dataSourcePoolMetadataProvider.getDataSourcePoolMetadata(dataSource);
    }

    @Override
    public void registryMerer(String moudleName, String beanName, DataSource dataSource) {
        this.registry((DataSource)this.getRealBean(dataSource));
    }

    public void registry(DataSource dataSource) {
        String tag = beanMapTag.get(dataSource);
        DWAbstractDataSourcePoolMetadata dataSourceMetadata = this.getDataSourceMetadata(dataSource);
        if (Objects.nonNull((Object)dataSourceMetadata)) {
            Gauge.builder((String)"dwjdbc.connections.active", (Object)"jdbc.connections.active", s -> dataSourceMetadata.getActive().intValue()).tag("name", tag).register(this.registry);
            Gauge.builder((String)"dwjdbc.connections.max", (Object)"jdbc.connections.max", s -> dataSourceMetadata.getMax().intValue()).tag("name", tag).register(this.registry);
            Gauge.builder((String)"dwjdbc.connections.min", (Object)"jdbc.connections.min", s -> dataSourceMetadata.getMin().intValue()).tag("name", tag).register(this.registry);
            Gauge.builder((String)"dwjdbc.connections.current", (Object)"jdbc.connections.current", s -> dataSourceMetadata.getPooling().intValue()).tag("name", tag).register(this.registry);
        }
    }

    @Override
    public Map<Object, String> getBeanMapTagMap() {
        return beanMapTag;
    }

    private static class CachingDataSourcePoolMetadataProvider
    implements DWDataSourcePoolMetadataProvider {
        private static final Map<DataSource, DWAbstractDataSourcePoolMetadata> cache = new ConcurrentReferenceHashMap();
        private final DWDataSourcePoolMetadataProvider metadataProvider;

        CachingDataSourcePoolMetadataProvider(DWDataSourcePoolMetadataProvider metadataProvider) {
            this.metadataProvider = metadataProvider;
        }

        @Override
        public DWAbstractDataSourcePoolMetadata getDataSourcePoolMetadata(DataSource dataSource) {
            DWAbstractDataSourcePoolMetadata metadata = cache.get(dataSource);
            if (metadata == null) {
                metadata = this.metadataProvider.getDataSourcePoolMetadata(dataSource);
                cache.put(dataSource, metadata);
            }
            return metadata;
        }
    }
}

