/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.metrics;

import com.digiwin.app.autoconfigure.metrics.DWAbstractModuleBeanMetricsProcessor;
import com.digiwin.app.module.DWModuleClassLoader;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.CollectionUtils;

public class DWModuleMetricsContainerBeanPostProcessor
implements BeanPostProcessor {
    private List<DWAbstractModuleBeanMetricsProcessor> processors;

    public DWModuleMetricsContainerBeanPostProcessor(List<DWAbstractModuleBeanMetricsProcessor> processors) {
        this.processors = CollectionUtils.isEmpty(processors) ? Collections.emptyList() : processors;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        for (DWAbstractModuleBeanMetricsProcessor processor : this.processors) {
            if (!processor.accept(bean)) continue;
            String moduleName = DWModuleClassLoader.getCurrentModuleName();
            processor.process(moduleName, beanName, bean);
        }
        return bean;
    }
}

