/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metrics;

import com.digiwin.app.autoconfigure.metrics.DWAbstractModuleBeanMetricsProcessor;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.dbutils.QueryRunner;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

public class QueryRunnerMetricsInterceptor
extends DWAbstractModuleBeanMetricsProcessor<DataSource>
implements MethodInterceptor {
    @Autowired
    @Lazy
    MeterRegistry registry;
    private static Map<Object, String> beanMapTag = new HashMap<Object, String>();
    private final String METRICS_NAME = "dwjdbc.execute";

    public QueryRunnerMetricsInterceptor(Map<String, DataSource> dataSourceMap) {
        if (!CollectionUtils.isEmpty(dataSourceMap)) {
            dataSourceMap.forEach((beanName, bean) -> {
                DataSource realBean = (DataSource)this.getRealBean(bean);
                if (!beanMapTag.containsKey(realBean)) {
                    beanMapTag.put(realBean, (String)beanName);
                }
            });
        }
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Object result = null;
        try {
            result = methodInvocation.proceed();
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            stopWatch.stop();
            Object target = new DirectFieldAccessor((Object)methodInvocation).getPropertyValue("target");
            if (target instanceof QueryRunner) {
                DataSource internalDataSource = this.getInternalDataSource((QueryRunner)target);
                String tagValue = beanMapTag.get(internalDataSource);
                Timer.builder((String)"dwjdbc.execute").tag("name", tagValue).register(this.registry).record(stopWatch.getTotalTimeMillis(), TimeUnit.MILLISECONDS);
            }
        }
        return result;
    }

    DataSource getInternalDataSource(QueryRunner queryRunner) {
        return (DataSource)this.getRealBean(queryRunner.getDataSource());
    }

    @Override
    public void registryMerer(String moduleName, String beanName, DataSource bean) {
        String tagValue = beanMapTag.get(this.getRealBean(bean));
        Timer.builder((String)"dwjdbc.execute").tag("name", tagValue).register(this.registry);
    }

    @Override
    public Map<Object, String> getBeanMapTagMap() {
        return beanMapTag;
    }
}

